var searchResultProvider = new SearchResultsProvider("ALG", "AutoLISP Developer's Guide");
searchResultProvider.setTopicInfoList(["",{"title":"Introduction",
"href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-5bb9.htm",
"description":"For years, AutoLISP® has set the standard for customizing AutoCAD®. Now Visual LISP® (VLISP) represents the next generation of LISP for AutoCAD, by adding significantly more capabilities. VLISP extends the language to interface with objects through the Microsoft ActiveX® Automation interface, and enhances the ability of AutoLISP to respond to events through the implementation of reactor functions. As a development tool, VLISP provides a complete, integrated development environment (IDE) that includes a compiler, debugger, and other tools to increase productivity when customizing AutoCAD.",
"ancestors":[]},
{"title":"AutoLISP and Visual LISP",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79c3.htm",
"description":"AutoLISP is a programming language designed for extending and customizing AutoCAD functionality. It is based on the LISP programming language, whose origins date back to the late 1950s. LISP was originally designed for use in Artificial Intelligence (AI) applications, and is still the basis for many AI applications.",
"ancestors":[{"title": "Introduction","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-5bb9.htm"}]},
{"title":"What Visual LISP Offers",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79c2.htm",
"description":"During the development cycle of an AutoLISP application or routine, the AutoLISP user performs a number of operations that are not available within the AutoCAD software. Some of these operations—like text editing—are available with other software tools. Others, such as full AutoLISP source-level debugging, are introduced only with VLISP. In VLISP, you perform most of the necessary operations inside a single environment. This permits text editing, program debugging, and interaction with AutoCAD and other applications.",
"ancestors":[{"title": "Introduction","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-5bb9.htm"},{"title": "AutoLISP and Visual LISP","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79c3.htm"}]},
{"title":"Working with Visual LISP and AutoCAD",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79c0.htm",
"description":"VLISP contains its own set of windows and menus that are distinct from the rest of AutoCAD, but VLISP does not run independently of AutoCAD. Whenever you work in VLISP, AutoCAD must also be running. When you run AutoLISP programs from the VLISP IDE, you will usually need to interact with the AutoCAD graphics or Command windows to respond to program prompts.",
"ancestors":[{"title": "Introduction","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-5bb9.htm"},{"title": "AutoLISP and Visual LISP","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79c3.htm"}]},
{"title":"Using Visual LISP Documentation",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79be.htm",
"description":"The AutoLISP Developer\'s Guide explains how to use the Visual LISP IDE and how to build and run AutoLISP applications. This guide also introduces the constructs of the AutoLISP language.",
"ancestors":[{"title": "Introduction","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-5bb9.htm"}]},
{"title":"Related Documents",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79b9.htm",
"description":"In addition to the AutoLISP Reference and the AutoLISP Tutorial, several other AutoCAD publications may be required by users building applications with Visual LISP:",
"ancestors":[{"title": "Introduction","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-5bb9.htm"}]},
{"title":"Using the Visual LISP Environment",
"href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm",
"description":"",
"ancestors":[]},
{"title":"Getting Started",
"href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-54c7.htm",
"description":"You can use Visual LISP to increase your productivity by compiling programs, stepping through code, and debugging.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"}]},
{"title":"Starting Visual LISP",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79b7.htm",
"description":"The Visual LISP (VLISP) interactive development environment runs in a separate set of windows from the rest of AutoCAD® . You must explicitly start VLISP to work in the interactive development environment.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Getting Started","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-54c7.htm"}]},
{"title":"Exploring the Visual LISP User Interface",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79b4.htm",
"description":"When you first start Visual LISP, the following components are displayed:",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Getting Started","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-54c7.htm"}]},
{"title":"Introducing the Visual LISP Text Editor",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79b3.htm",
"description":"You will spend much of your time in VLISP creating or modifying AutoLISP programs. VLISP comes with an integrated text editor for you to use with AutoLISP code.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Getting Started","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-54c7.htm"},{"title": "Exploring the Visual LISP User Interface","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79b4.htm"}]},
{"title":"Other Visual LISP Windows",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79b0.htm",
"description":"VLISP displays some output in the Console window, but several VLISP functions create their own windows in which to display results. For example, when you trace the sequence of events during a running AutoLISP program, the Trace function opens a window and displays program events. You cannot enter text in these output windows, but you can copy text from them and paste the text into the editor or Console windows.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Getting Started","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-54c7.htm"},{"title": "Exploring the Visual LISP User Interface","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79b4.htm"}]},
{"title":"Touring the Visual LISP Menus",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79af.htm",
"description":"You can issue VLISP commands by choosing from the various menu items. For example, from the File menu you can create a new AutoLISP program file, select an existing program file to edit, and print the file you\'re editing.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Getting Started","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-54c7.htm"}]},
{"title":"Variable Menu Contents",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79ae.htm",
"description":"Menu contents may vary depending on which VLISP window (for example, text editor, Console) is active. To activate a different window, click in the window\'s title bar, or in any empty area of that window.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Getting Started","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-54c7.htm"},{"title": "Touring the Visual LISP Menus","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79af.htm"}]},
{"title":"Visual LISP Menu Summary",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79ab.htm",
"description":"The following table summarizes the VLISP menu items.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Getting Started","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-54c7.htm"},{"title": "Touring the Visual LISP Menus","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79af.htm"}]},
{"title":"Understanding the Console Window",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79a9.htm",
"description":"From the VLISP Console window, you can enter and run AutoLISP commands and see the results. This is similar to what you can do in the AutoCAD Command window, but there are a few differences—some subtle—in how you accomplish the same task in these two windows. For example, to display the current value of an AutoLISP variable in VLISP, you simply type the variable name in the Console window and press ENTER. To view the value of a variable in AutoCAD, you must precede the variable name with an exclamation point (!) when you type it in the Command window.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Getting Started","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-54c7.htm"}]},
{"title":"Understanding the Visual LISP Text Editor",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79a7.htm",
"description":"The VLISP text editor is much more than a writing tool, it\'s a central component of the VLISP programming environment. To appreciate the versatility and value of the VLISP text editor, you need to be familiar with the AutoLISP language. If you are not yet familiar with AutoLISP, you can learn the basics in chapter 8, and find additional information in chapter 9, and chapter 10,",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Getting Started","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-54c7.htm"}]},
{"title":"Loading and Running AutoLISP Programs",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79a6.htm",
"description":"Once you have opened an AutoLISP program file in the VLISP text editor, you can load and run it. Loading is the process by which functions in a program file are made available to the VLISP command interpreter. You can try this with the drawline.lsp sample program.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Getting Started","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-54c7.htm"}]},
{"title":"Running Selected Lines of Code",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79a1.htm",
"description":"With VLISP, you can select lines of code in the text editor window and run only the selected code, instead of the whole program.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Getting Started","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-54c7.htm"},{"title": "Loading and Running AutoLISP Programs","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79a6.htm"}]},
{"title":"Using Extended AutoLISP Functions",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-799d.htm",
"description":"VLISP provides some extensions to the AutoLISP language that are not loaded automatically when you start AutoCAD. These functions have names that begin with vla-, vlax-, and vlr. The vla- functions implement ActiveX® support in AutoLISP (described in ). The vlax- functions provide ActiveX utility and data conversion functions, dictionary handling functions, and curve measurement functions. The vlr- functions provide support for AutoCAD reactors. Before you can use any of these functions, you need to load the AutoLISP extensions with the following function call:",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Getting Started","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-54c7.htm"},{"title": "Loading and Running AutoLISP Programs","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79a6.htm"}]},
{"title":"Exiting Visual LISP",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-799c.htm",
"description":"When you are finished with your VLISP session, you can close the program by either choosing Exit from the File menu or clicking the Windows Close button. Note that AutoCAD does not completely unload VLISP but merely closes all VLISP windows.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Getting Started","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-54c7.htm"}]},
{"title":"Developing Programs with Visual LISP",
"href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-544b.htm",
"description":"With Visual LISP, you can format your code and automatically detect syntax errors.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"}]},
{"title":"Getting Organized",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-799b.htm",
"description":"To develop an AutoLISP program with VLISP you must perform the following steps:",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Developing Programs with Visual LISP","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-544b.htm"}]},
{"title":"Using the Console Window",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7999.htm",
"description":"Most programming in VLISP takes place within the confines of the VLISP text editor, but the ability to program interactively with AutoLISP provides some unique advantages to the development process. In the VLISP Console window you can enter AutoLISP code and immediately see the results of executing that code.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Developing Programs with Visual LISP","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-544b.htm"}]},
{"title":"Understanding Console Behavior",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7998.htm",
"description":"The VLISP Console window is similar in some respects to the AutoCAD® Command window, but it provides many more features. Although the Console window and the AutoCAD Command window provide similar capabilities, you don\'t always use the same process to accomplish identical tasks. For example, to display the current value of an AutoLISP variable in VLISP, you simply type the variable name in the Console window and press ENTER. To view the value of a variable in AutoCAD, you must precede the variable name with an exclamation point (!) when you enter it at the AutoCAD Command prompt.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Developing Programs with Visual LISP","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-544b.htm"},{"title": "Using the Console Window","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7999.htm"}]},
{"title":"Using the Console Window History",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7996.htm",
"description":"You can retrieve text you previously entered in the Console window by pressing TAB while at the Console prompt. Each time you press TAB, the previously entered text replaces the text at the Console prompt. You can repeatedly press TAB until you cycle through all the text entered at the Console prompt during your VLISP session. After you\'ve scrolled to the first entered line, VLISP starts again by retrieving the last command entered in the Console window, and the cycle repeats. Press SHIFT + TAB to scroll the input history in the opposite direction.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Developing Programs with Visual LISP","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-544b.htm"},{"title": "Using the Console Window","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7999.htm"},{"title": "Understanding Console Behavior","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7998.htm"}]},
{"title":"Interrupting Commands and Clearing the Console Input Area",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7991.htm",
"description":"To interrupt a command entered in the Console window, press SHIFT + ESC. For example, if you enter an invalid function call like the following:",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Developing Programs with Visual LISP","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-544b.htm"},{"title": "Using the Console Window","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7999.htm"},{"title": "Understanding Console Behavior","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7998.htm"}]},
{"title":"Using the Console Window with Multiple Drawings",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7990.htm",
"description":"There is a single Console window for all open AutoCAD drawing documents. When you scroll through the Console window, you see commands entered in all document contexts. This differs from the AutoCAD Command window, which shows only the commands issued against the current drawing. In other words, each AutoCAD drawing has its own Command window, but all drawings share the same VLISP Console prompt.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Developing Programs with Visual LISP","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-544b.htm"},{"title": "Using the Console Window","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7999.htm"}]},
{"title":"Using the Console Shortcut Menu",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-798f.htm",
"description":"The most important functions needed when working with the VLISP Console window are combined into a shortcut menu for fast access. Right-click anywhere in the Console window or press SHIFT + F10 to display the shortcut menu.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Developing Programs with Visual LISP","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-544b.htm"},{"title": "Using the Console Window","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7999.htm"}]},
{"title":"Logging Console Window Activity",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-798d.htm",
"description":"You can keep a record of all Console window activity by logging the activity in a file. Later, you can view the file and review the activity that occurred in the Console window.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Developing Programs with Visual LISP","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-544b.htm"},{"title": "Using the Console Window","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7999.htm"}]},
{"title":"Using the Text Editor",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-798a.htm",
"description":"If you just need to run a few simple AutoLISP expressions, entering the expressions in the VLISP System Console may suffice. For anything more than that, however, you will need to use the VLISP text editor and save your AutoLISP code in a file.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Developing Programs with Visual LISP","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-544b.htm"}]},
{"title":"Editing a File",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7989.htm",
"description":"To open a new file in the VLISP text editor, choose File New File from the menu bar. An empty editor window appears on the screen, and you can begin entering text.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Developing Programs with Visual LISP","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-544b.htm"},{"title": "Using the Text Editor","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-798a.htm"}]},
{"title":"Undoing Your Last Change",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7987.htm",
"description":"You can reverse your last edit action by choosing Edit Undo from the VLISP menu bar. You can undo a virtually unlimited number of changes, back to the point at which you last saved the file.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Developing Programs with Visual LISP","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-544b.htm"},{"title": "Using the Text Editor","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-798a.htm"},{"title": "Editing a File","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7989.htm"}]},
{"title":"Creating Automatic Backup Files",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7984.htm",
"description":"VLISP supports the automatic creation of backup copies of files loaded by the text editor. The actual backup creation occurs when you save the file for the first time. Backup files have the same name as your original file, except the file extension begins with an underscore (_) and is followed by the first two characters of the original extension. For example, the backup file for drawline.lsp would be drawline._ls.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Developing Programs with Visual LISP","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-544b.htm"},{"title": "Using the Text Editor","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-798a.htm"},{"title": "Editing a File","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7989.htm"}]},
{"title":"Restoring from a Backup File",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7983.htm",
"description":"If a backup file exists, you can restore the file you are editing to its original content, reversing all the changes you made. From the File menu, choose Revert to restore the file. If there is no backup file for the text in the editor window, VLISP displays an error message.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Developing Programs with Visual LISP","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-544b.htm"},{"title": "Using the Text Editor","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-798a.htm"},{"title": "Editing a File","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7989.htm"}]},
{"title":"Editing an Existing File",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7982.htm",
"description":"Choose File Open from the VLISP menu to open an existing file. VLISP opens a new text editor window for the file you select. You can open any number of files and work on them simultaneously. VLISP places each file in its own editor window.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Developing Programs with Visual LISP","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-544b.htm"},{"title": "Using the Text Editor","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-798a.htm"},{"title": "Editing a File","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7989.htm"}]},
{"title":"Using the Text Editor Shortcut Menu",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7980.htm",
"description":"Right-clicking your mouse in an active VLISP text editor window brings up a shortcut menu for quick access to frequently used commands. Depending on whether there is text highlighted in the editor window and depending on the position of the cursor, some commands on the shortcut menu may be inactive. The following table summarizes the editor shortcut commands:",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Developing Programs with Visual LISP","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-544b.htm"},{"title": "Using the Text Editor","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-798a.htm"}]},
{"title":"Using Keyboard Shortcuts in the Text Editor",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-797e.htm",
"description":"The VLISP text editor provides numerous keyboard shortcuts you can use instead of menu selections and mouse clicks.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Developing Programs with Visual LISP","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-544b.htm"},{"title": "Using the Text Editor","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-798a.htm"}]},
{"title":"Correcting Text",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-797d.htm",
"description":"You can delete words or lines using the following shortcuts:",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Developing Programs with Visual LISP","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-544b.htm"},{"title": "Using the Text Editor","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-798a.htm"},{"title": "Using Keyboard Shortcuts in the Text Editor","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-797e.htm"}]},
{"title":"Selecting Text",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-797b.htm",
"description":"The simplest method to select text is to double-click your left mouse button. The amount of text selected depends on the location of your cursor.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Developing Programs with Visual LISP","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-544b.htm"},{"title": "Using the Text Editor","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-798a.htm"},{"title": "Using Keyboard Shortcuts in the Text Editor","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-797e.htm"}]},
{"title":"Navigation Shortcuts",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7978.htm",
"description":"In addition to using the cursor arrow keys, you can use the following VLISP editor shortcuts to navigate through your text:",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Developing Programs with Visual LISP","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-544b.htm"},{"title": "Using the Text Editor","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-798a.htm"},{"title": "Using Keyboard Shortcuts in the Text Editor","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-797e.htm"}]},
{"title":"Indenting Shortcuts",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7976.htm",
"description":"Most indenting of program code is best handled by the VLISP automatic code formatting and Smart Indent features, and by customizing the formatter\'s options (see ). But there are some things you may want to do by yourself.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Developing Programs with Visual LISP","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-544b.htm"},{"title": "Using the Text Editor","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-798a.htm"},{"title": "Using Keyboard Shortcuts in the Text Editor","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-797e.htm"}]},
{"title":"Moving and Copying Text",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7974.htm",
"description":"In addition to using the standard Windows Cut, Copy, and Paste functions, the VLISP text editor allows you to drag text from one location to another within the edit window.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Developing Programs with Visual LISP","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-544b.htm"},{"title": "Using the Text Editor","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-798a.htm"}]},
{"title":"Searching for Text",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7971.htm",
"description":"The VLISP text editor has extensive text-searching capabilities. From the Search menu, choose Find to begin a search, or choose the Find toolbar button. VLISP displays the Find dialog box.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Developing Programs with Visual LISP","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-544b.htm"},{"title": "Using the Text Editor","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-798a.htm"}]},
{"title":"Choosing Search Options",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-796f.htm",
"description":"Under the Search heading, indicate the extent of the search you want VLISP to conduct. You can choose one of the following:",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Developing Programs with Visual LISP","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-544b.htm"},{"title": "Using the Text Editor","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-798a.htm"},{"title": "Searching for Text","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7971.htm"}]},
{"title":"Repeating an Earlier Search",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-796e.htm",
"description":"VLISP saves each search string you enter in a pull-down list on the toolbar.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Developing Programs with Visual LISP","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-544b.htm"},{"title": "Using the Text Editor","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-798a.htm"},{"title": "Searching for Text","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7971.htm"}]},
{"title":"Replacing Text",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-796b.htm",
"description":"The Search menu contains a Replace function that is used to replace the search text with a text string that you specify.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Developing Programs with Visual LISP","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-544b.htm"},{"title": "Using the Text Editor","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-798a.htm"},{"title": "Searching for Text","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7971.htm"}]},
{"title":"Bookmarking Text",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7968.htm",
"description":"The bookmark feature helps you navigate through VLISP text editor windows by letting you mark up to 32 positions (bookmarks) in each window. Once 32 bookmarks are set, adding a new bookmark results in the oldest bookmark being removed.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Developing Programs with Visual LISP","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-544b.htm"},{"title": "Using the Text Editor","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-798a.htm"}]},
{"title":"Using Console and Editor Coding Aids",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-795b.htm",
"description":"Several VLISP coding aids are useful at both the Console and text editor windows. One highly visual aid is the assignment of colors to AutoLISP language elements. Color coding helps you detect syntax errors in your code. VLISP also contains several features to help you determine the names of variables and functions that you need to refer to in your program, and shortcuts to online Help for AutoLISP functions.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Developing Programs with Visual LISP","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-544b.htm"}]},
{"title":"Understanding Visual LISP Color Coding",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-795a.htm",
"description":"As soon as you enter text in the VLISP Console or text editor windows, VLISP attempts to determine if the entered word is a built-in AutoLISP function, a number, a string, or some other language element. VLISP assigns every type of element its own color. This helps you detect missing quotes or misspelled function names. The default color scheme is shown in the following table.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Developing Programs with Visual LISP","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-544b.htm"},{"title": "Using Console and Editor Coding Aids","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-795b.htm"}]},
{"title":"Using the Apropos Feature",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7958.htm",
"description":"The Apropos feature is a tool that searches the VLISP symbol table. The symbol table contains every symbol read by the AutoLISP reader. This includes symbols in user programs and symbols that implement the AutoLISP language.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Developing Programs with Visual LISP","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-544b.htm"},{"title": "Using Console and Editor Coding Aids","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-795b.htm"}]},
{"title":"Using the Results of an Apropos Search",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7954.htm",
"description":"Apropos displays the symbols matching your search criteria in the following window:",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Developing Programs with Visual LISP","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-544b.htm"},{"title": "Using Console and Editor Coding Aids","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-795b.htm"},{"title": "Using the Apropos Feature","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7958.htm"}]},
{"title":"Letting Visual LISP Help You Complete Words",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-794e.htm",
"description":"Two VLISP features, Complete Word by Match and Complete Word by Apropos, allow you to type part of a word and get help in completing the rest.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Developing Programs with Visual LISP","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-544b.htm"},{"title": "Using Console and Editor Coding Aids","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-795b.htm"}]},
{"title":"Completing a Word by Matching",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-794d.htm",
"description":"Using Complete Word by Match, VLISP completes a partially entered word by matching the part you have typed with another word in the same window. For example, suppose the following shows the history of your VLISP Console window:",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Developing Programs with Visual LISP","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-544b.htm"},{"title": "Using Console and Editor Coding Aids","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-795b.htm"},{"title": "Letting Visual LISP Help You Complete Words","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-794e.htm"}]},
{"title":"Completing a Word by Apropos",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-794a.htm",
"description":"With the Complete Word by Apropos feature, VLISP completes a partially entered word with a matching symbol name from the VLISP symbol table. To demonstrate this feature, assume you have entered the following commands shown in your VLISP Console window:",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Developing Programs with Visual LISP","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-544b.htm"},{"title": "Using Console and Editor Coding Aids","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-795b.htm"},{"title": "Letting Visual LISP Help You Complete Words","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-794e.htm"}]},
{"title":"Getting Help for AutoLISP Functions",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7944.htm",
"description":"If you select a function name anywhere in a text editor or Console window, and then press the Help button on the Tools toolbar, VLISP displays help for the function. This feature works for any function recognized by VLISP. You can also press CTRL + F1 to view Help for the selected function.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Developing Programs with Visual LISP","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-544b.htm"},{"title": "Using Console and Editor Coding Aids","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-795b.htm"}]},
{"title":"Formatting Code with Visual LISP",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7943.htm",
"description":"The VLISP code formatter arranges the text of AutoLISP expressions in a style that improves text appearance and readability. The code formatter includes a Smart Indent feature to arrange the indentation of program code automatically. The code formatter works automatically as you enter code in a VLISP text editor window. You can also explicitly invoke the formatter to rearrange selected blocks of text or all text in a VLISP editor window. This is useful for formatting text you copy from other editors, or for reformatting your code in a different style.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Developing Programs with Visual LISP","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-544b.htm"}]},
{"title":"Understanding Visual LISP Formatting Styles",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-793e.htm",
"description":"The VLISP formatter chooses the appropriate formatting style according to rules that are explained in this section. You can influence the choice of VLISP styles through the options you set in the Format Options dialog box. To display the Format Options dialog box, choose Tools Environment Options Visual LISP Format Options from the VLISP menu.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Developing Programs with Visual LISP","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-544b.htm"},{"title": "Formatting Code with Visual LISP","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7943.htm"}]},
{"title":"Plane Style",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-793c.htm",
"description":"In the Plane style, all arguments are placed in the same line, separated by a single space:",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Developing Programs with Visual LISP","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-544b.htm"},{"title": "Formatting Code with Visual LISP","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7943.htm"},{"title": "Understanding Visual LISP Formatting Styles","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-793e.htm"}]},
{"title":"Wide Style",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-793a.htm",
"description":"In the Wide style, the first argument is placed in the same line as the function name, and other arguments are aligned in a column below the first argument.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Developing Programs with Visual LISP","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-544b.htm"},{"title": "Formatting Code with Visual LISP","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7943.htm"},{"title": "Understanding Visual LISP Formatting Styles","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-793e.htm"}]},
{"title":"Narrow Style",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7938.htm",
"description":"In the Narrow style, the first argument is placed on the next line after the function name, and other arguments are aligned in a column below the first argument. The displacement of the first argument\'s starting position relative to the expression starting position is controlled by the value of the Narrow Style Indentation environment option (in the following example, this value is equal to 2):",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Developing Programs with Visual LISP","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-544b.htm"},{"title": "Formatting Code with Visual LISP","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7943.htm"},{"title": "Understanding Visual LISP Formatting Styles","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-793e.htm"}]},
{"title":"Column Style",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7937.htm",
"description":"In the Column style, all elements are positioned in a column. This style is appropriate for displaying quoted lists and COND-expression clauses. For example, the following text:",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Developing Programs with Visual LISP","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-544b.htm"},{"title": "Formatting Code with Visual LISP","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7943.htm"},{"title": "Understanding Visual LISP Formatting Styles","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-793e.htm"}]},
{"title":"Applying Formatting Options",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7936.htm",
"description":"In addition to affecting the basic formatting styles, you can choose from a number of Visual LISP format options.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Developing Programs with Visual LISP","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-544b.htm"},{"title": "Formatting Code with Visual LISP","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7943.htm"}]},
{"title":"Close Parenthesis Style",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7935.htm",
"description":"This style controls the position of the close parenthesis for multiple-line formatting styles. You can select one of the following options:",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Developing Programs with Visual LISP","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-544b.htm"},{"title": "Formatting Code with Visual LISP","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7943.htm"},{"title": "Applying Formatting Options","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7936.htm"}]},
{"title":"Insert Form-Closing Comment",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7933.htm",
"description":"If you select this option, VLISP adds a comment following the close of an expression. However, the option takes effect only if the Close Parenthesis Style format setting is either Close at the New Line with Inner Indentation or Close at the New Line with Outer Indentation.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Developing Programs with Visual LISP","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-544b.htm"},{"title": "Formatting Code with Visual LISP","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7943.htm"},{"title": "Applying Formatting Options","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7936.htm"}]},
{"title":"Preserve Existing Line Breaks",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7931.htm",
"description":"When the Preserve Existing Line Breaks option is on, the VLISP formatter inserts new lines whenever a new line is detected in the text it is formatting. When the option is off, the formatter can squeeze a multiple-line expression to the Plane style, if it fits within the right margin.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Developing Programs with Visual LISP","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-544b.htm"},{"title": "Formatting Code with Visual LISP","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7943.htm"},{"title": "Applying Formatting Options","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7936.htm"}]},
{"title":"Split Comments",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7930.htm",
"description":"When the Split Comments option is on, the formatter splits long comments that extend past the right margin.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Developing Programs with Visual LISP","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-544b.htm"},{"title": "Formatting Code with Visual LISP","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7943.htm"},{"title": "Applying Formatting Options","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7936.htm"}]},
{"title":"Long List Format Style",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-792f.htm",
"description":"Long lists are lists of formal arguments in defun, lambda, or quoted lists containing more than five elements. The Long List format style applies to lists that do not fit on a single line (within the Right Text Margin).",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Developing Programs with Visual LISP","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-544b.htm"},{"title": "Formatting Code with Visual LISP","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7943.htm"},{"title": "Applying Formatting Options","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7936.htm"}]},
{"title":"Setting Case for Symbols",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-792e.htm",
"description":"By default, the VLISP formatter does not change the case of AutoLISP symbols. You can set the formatter to change the case of symbols according to the VLISP protection state for symbols.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Developing Programs with Visual LISP","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-544b.htm"},{"title": "Formatting Code with Visual LISP","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7943.htm"},{"title": "Applying Formatting Options","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7936.htm"}]},
{"title":"Applying Visual LISP Comment Styles",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-792c.htm",
"description":"The VLISP formatter recognizes five types of AutoLISP comments, and positions each comment according to its type.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Developing Programs with Visual LISP","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-544b.htm"},{"title": "Formatting Code with Visual LISP","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7943.htm"}]},
{"title":"Saving and Restoring Formatting Options",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-792a.htm",
"description":"To save your formatting options so that they carry over to subsequent VLISP sessions, choose Tools Save Settings from the VLISP menu. Alternatively, you can save the current settings specifically for the program in the active text editor window. VLISP saves formatter settings in a program when the Save Formatting Options in Source File option is selected. To select or cancel this option, choose Environment Options Visual LISP Format Options from the Tools menu. If the option is in effect, VLISP adds formatting information as comments at the end of the program, when you run the formatter.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Developing Programs with Visual LISP","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-544b.htm"},{"title": "Formatting Code with Visual LISP","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7943.htm"}]},
{"title":"Formatter Restrictions",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7929.htm",
"description":"The following restrictions apply to the VLISP code formatter:",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Developing Programs with Visual LISP","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-544b.htm"},{"title": "Formatting Code with Visual LISP","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7943.htm"}]},
{"title":"Formatting Shortcut Keys",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7927.htm",
"description":"Press CTRL + E while in an active VLISP text editor window to display a list containing the following editor options.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Developing Programs with Visual LISP","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-544b.htm"},{"title": "Formatting Code with Visual LISP","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7943.htm"}]},
{"title":"Checking for Syntax Errors",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7925.htm",
"description":"One main attraction of using VLISP is the extensive debugging tools it provides. These tools allow you to watch what your program is doing while it is executing, and to take a “snapshot” of your program at any point. However, VLISP also provides a number of features designed to detect program errors before you run the program.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Developing Programs with Visual LISP","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-544b.htm"}]},
{"title":"Checking the Balance of Parentheses",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7924.htm",
"description":"AutoLISP uses parentheses more frequently than most other computer languages. One of the most frequent syntax errors in AutoLISP is an unequal number of open and close parentheses. VLISP includes a number of tools to help you detect unbalanced or unmatched parentheses.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Developing Programs with Visual LISP","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-544b.htm"},{"title": "Checking for Syntax Errors","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7925.htm"}]},
{"title":"Using Color Coding to Detect Syntax Errors",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7922.htm",
"description":"The AutoCAD Sample\VisualLISP directory contains a file named drawline-with-errors.lsp. It is similar to the drawline.lsp program file introduced earlier in this manual, but it contains a couple of errors. Open the file in VLISP, so that you can see how color is used in the file:",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Developing Programs with Visual LISP","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-544b.htm"},{"title": "Checking for Syntax Errors","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7925.htm"}]},
{"title":"Using the Check Command to Look for Syntax Errors",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7921.htm",
"description":"You can perform additional syntax checking with the VLISP Check command. The Check command can detect the following errors:",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Developing Programs with Visual LISP","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-544b.htm"},{"title": "Checking for Syntax Errors","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7925.htm"}]},
{"title":"Finding the Location of the Syntax Error in Your Program",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-791a.htm",
"description":"If you double-click on the error message in the Build Output window, VLISP activates the editor window, places the cursor at the beginning of the statement that caused the error, and highlights the entire expression, as follows:",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Developing Programs with Visual LISP","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-544b.htm"},{"title": "Checking for Syntax Errors","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7925.htm"},{"title": "Using the Check Command to Look for Syntax Errors","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7921.htm"}]},
{"title":"Debugging Programs",
"href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-5194.htm",
"description":"To debug a program, you can trace execution, trace the values of variables during execution, and view the sequence in which expressions are evaluated.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"}]},
{"title":"Introducing Visual LISP Debugging Features",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7918.htm",
"description":"Debugging is usually the most time-consuming stage in the development of any program. For this reason, VLISP includes a powerful debugger that provides the following features:",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Debugging Programs","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-5194.htm"}]},
{"title":"Learning by Example",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7916.htm",
"description":"This section takes you through a VLISP sample program and demonstrates some VLISP debugging facilities along the way. You can find the sample program, yinyang.lsp, in the Sample\VisualLISP directory under the default AutoCAD installation path. Open the file in VLISP so that you can try the examples in this section.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Debugging Programs","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-5194.htm"}]},
{"title":"Stepping through the Debugging Example",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7915.htm",
"description":"First, load the yinyang.lsp file and run the yinyang function to see what it does. The function draws the yin-yang symbol, which is used in many religions:",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Debugging Programs","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-5194.htm"},{"title": "Learning by Example","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7916.htm"}]},
{"title":"Setting a Breakpoint to Interrupt Program Execution",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7913.htm",
"description":"Begin by entering some debugging information in the text editor window containing the yinyang.lsp program.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Debugging Programs","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-5194.htm"},{"title": "Learning by Example","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7916.htm"},{"title": "Stepping through the Debugging Example","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7915.htm"}]},
{"title":"Stepping through the Program",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-790d.htm",
"description":"The Step commands allow you to move through a program by executing one or more expressions at a time.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Debugging Programs","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-5194.htm"},{"title": "Learning by Example","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7916.htm"},{"title": "Stepping through the Debugging Example","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7915.htm"}]},
{"title":"Monitoring the Evaluation Results of an Expression",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7903.htm",
"description":"As you step through a program, you may want to monitor the values resulting from the evaluation of individual expressions.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Debugging Programs","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-5194.htm"},{"title": "Learning by Example","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7916.htm"},{"title": "Stepping through the Debugging Example","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7915.htm"}]},
{"title":"Continuing Program Execution",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-78fb.htm",
"description":"To continue running your program to the next breakpoint, or to the end, if there are no more breakpoints, press the Continue button on the Debug toolbar, or choose Debug Continue from the VLISP menu.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Debugging Programs","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-5194.htm"},{"title": "Learning by Example","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7916.htm"},{"title": "Stepping through the Debugging Example","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7915.htm"}]},
{"title":"Running in Animate Mode",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-78f9.htm",
"description":"Another debugging feature, animation, allows you to watch as VLISP steps through your program code and evaluates each expression. In Animate mode, it\'s as if VLISP repeatedly enters a Step Into command for you. Text editor windows highlight expressions being evaluated, and the Watch window continuously updates its data.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Debugging Programs","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-5194.htm"},{"title": "Learning by Example","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7916.htm"},{"title": "Stepping through the Debugging Example","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7915.htm"}]},
{"title":"Using the Visual LISP Debugging Features",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-78f6.htm",
"description":"In addition to setting breakpoints and running in Animate mode, as described in the section of this chapter, VLISP provides a number of other options for controlling program execution.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Debugging Programs","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-5194.htm"}]},
{"title":"Starting a Debugging Session",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-78f5.htm",
"description":"The easiest way to start debugging is to choose Debug Stop Once from the VLISP menu. When this item is selected, the evaluation of the first LISP expression will be interrupted. After that you can resume program execution using various Debugger commands. Another way to enter into the debugger mode is to set a breakpoint, as shown in .",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Debugging Programs","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-5194.htm"},{"title": "Using the Visual LISP Debugging Features","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-78f6.htm"}]},
{"title":"Understanding Break Loops",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-78f4.htm",
"description":"Expressions are the basic structural units of AutoLISP, and VLISP works by repeatedly reading, evaluating, and printing expressions. In LISP terminology, this is a read-eval-print loop.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Debugging Programs","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-5194.htm"},{"title": "Using the Visual LISP Debugging Features","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-78f6.htm"}]},
{"title":"Continuable Break Loops",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-78f3.htm",
"description":"There are continuable and noncontinuable break loops in VLISP. You can enter the continuable break loop at the very first break in program execution by any of the following methods:",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Debugging Programs","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-5194.htm"},{"title": "Using the Visual LISP Debugging Features","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-78f6.htm"},{"title": "Understanding Break Loops","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-78f4.htm"}]},
{"title":"Non-Continuable Break Loops",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-78e9.htm",
"description":"A non-continuable break loop is activated when an error causes program interruption and the Break on Error option is set. In a non-continuable break loop, you can access all variables in the error environment, but you cannot continue program execution or execute any of the Step commands. To distinguish between continuable and non-continuable break loops, check to see if the Step and Continue toolbar buttons are active.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Debugging Programs","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-5194.htm"},{"title": "Using the Visual LISP Debugging Features","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-78f6.htm"},{"title": "Understanding Break Loops","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-78f4.htm"}]},
{"title":"Using Breakpoints",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-78e8.htm",
"description":"Breakpoints allow you to mark a position in a program at which program execution should be interrupted. You can set breaks to occur before or after parenthetical expressions. Breakpoints can only be set from a VLISP text editor window.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Debugging Programs","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-5194.htm"},{"title": "Using the Visual LISP Debugging Features","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-78f6.htm"}]},
{"title":"Changing Breakpoint Highlight Colors",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-78e2.htm",
"description":"VLISP marks each breakpoint position with a colored rectangle, so you can easily locate the breakpoints in your program. By default, active breakpoints are marked in red. You can change this color by setting the :BPT-ACTIVE option in Tools Window Attributes Configure Current. See for more information on changing colors in VLISP windows.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Debugging Programs","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-5194.htm"},{"title": "Using the Visual LISP Debugging Features","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-78f6.htm"},{"title": "Using Breakpoints","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-78e8.htm"}]},
{"title":"Disabling Breakpoints Temporarily",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-78e1.htm",
"description":"When using multiple breakpoints within a source file, it may be useful to disable one or more breakpoints temporarily, but leave the breakpoint position defined for possible later use. This saves time over deleting and restoring the breakpoint.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Debugging Programs","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-5194.htm"},{"title": "Using the Visual LISP Debugging Features","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-78f6.htm"},{"title": "Using Breakpoints","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-78e8.htm"}]},
{"title":"Listing and Viewing the Breakpoints in Your Program",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-78dd.htm",
"description":"From the View menu, choose Breakpoints Window to see a list of all breakpoints currently defined to VLISP:",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Debugging Programs","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-5194.htm"},{"title": "Using the Visual LISP Debugging Features","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-78f6.htm"},{"title": "Using Breakpoints","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-78e8.htm"}]},
{"title":"Life Cycle of a Breakpoint",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-78db.htm",
"description":"You can set breakpoints in a program either before or after you load the program. However, if you change the text in a program after loading the program, and then add a breakpoint, the breakpoint only takes effect after you reload the code.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Debugging Programs","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-5194.htm"},{"title": "Using the Visual LISP Debugging Features","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-78f6.htm"},{"title": "Using Breakpoints","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-78e8.htm"}]},
{"title":"Using Visual LISP Data Inspection Tools",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-78d8.htm",
"description":"VLISP gives you almost unlimited access to symbols, values, and functions at any stage of program execution. The VLISP data inspection tools are implemented as modeless windows (except for the Symbol Service dialog box), meaning they stay on the screen as long as you need them, no matter what your program does.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Debugging Programs","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-5194.htm"}]},
{"title":"Using the Watch Window",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-78d3.htm",
"description":"The Watch window monitors the values of AutoLISP variables during program execution. Each Watch window element line displays the name of a variable and its current value, as illustrated in the following figure:",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Debugging Programs","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-5194.htm"},{"title": "Using Visual LISP Data Inspection Tools","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-78d8.htm"}]},
{"title":"Using the Watch Toolbar",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-78cd.htm",
"description":"The toolbar on the Watch window contains the following buttons:",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Debugging Programs","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-5194.htm"},{"title": "Using Visual LISP Data Inspection Tools","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-78d8.htm"},{"title": "Using the Watch Window","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-78d3.htm"}]},
{"title":"Using the Watch Item Shortcut Menu",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-78cc.htm",
"description":"To display the Watch Item shortcut menu, select an item in the watch list and right-click.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Debugging Programs","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-5194.htm"},{"title": "Using Visual LISP Data Inspection Tools","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-78d8.htm"},{"title": "Using the Watch Window","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-78d3.htm"}]},
{"title":"Understanding the Trace Stack Window",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-78cb.htm",
"description":"VLISP has a special debugging tool called a trace stack which is a historical record of the execution of functions within your program. (The term stack is derived from a computer programming structure of the same name.) The following figure illustrates adding and removing items from a stack. You can see why a stack structure is often referred to as LIFO—Last In, First Out:",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Debugging Programs","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-5194.htm"},{"title": "Using Visual LISP Data Inspection Tools","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-78d8.htm"}]},
{"title":"Stack Element Lists",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-78c9.htm",
"description":"A stack element is an individual record or line-item history within a trace stack. There are five kinds of elements that may appear within a stack:",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Debugging Programs","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-5194.htm"},{"title": "Using Visual LISP Data Inspection Tools","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-78d8.htm"},{"title": "Understanding the Trace Stack Window","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-78cb.htm"}]},
{"title":"Viewing the Current Trace Stack",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-78c7.htm",
"description":"To see the state of a function call stack while your program is suspended at a breakpoint, choose View Trace Stack from the VLISP menu, or click the Trace toolbar button. VLISP displays the Trace Stack window:",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Debugging Programs","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-5194.htm"},{"title": "Using Visual LISP Data Inspection Tools","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-78d8.htm"},{"title": "Understanding the Trace Stack Window","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-78cb.htm"}]},
{"title":"Displaying Information on a Trace Stack Element",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-78c4.htm",
"description":"To obtain more information about an element in the trace stack, select the element and right-click to display a shortcut menu.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Debugging Programs","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-5194.htm"},{"title": "Using Visual LISP Data Inspection Tools","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-78d8.htm"},{"title": "Understanding the Trace Stack Window","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-78cb.htm"}]},
{"title":"Using the Frame Binding Window",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-78c3.htm",
"description":"Choose the local variables item from the Trace Stack shortcut menu to display the Frame Binding window:",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Debugging Programs","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-5194.htm"},{"title": "Using Visual LISP Data Inspection Tools","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-78d8.htm"},{"title": "Understanding the Trace Stack Window","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-78cb.htm"}]},
{"title":"Understanding Keyword Frames",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-78c1.htm",
"description":"A keyword frame indicates a specific type of operation that occurs within the VLISP environment. The keyword indicates the type of operation. Keyword frames will appear in only two locations: at the very top of the stack, or at the very bottom of the stack.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Debugging Programs","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-5194.htm"},{"title": "Using Visual LISP Data Inspection Tools","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-78d8.htm"},{"title": "Understanding the Trace Stack Window","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-78cb.htm"}]},
{"title":"Understanding Special Function Call Frames",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-78be.htm",
"description":"There are two special function call frames.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Debugging Programs","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-5194.htm"},{"title": "Using Visual LISP Data Inspection Tools","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-78d8.htm"},{"title": "Understanding the Trace Stack Window","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-78cb.htm"}]},
{"title":"Viewing an Error Trace Stack",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-78bc.htm",
"description":"If your program terminates due to an error, choose Error Trace from the View menu to see the state of function invocations up to the time your program crashed:",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Debugging Programs","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-5194.htm"},{"title": "Using Visual LISP Data Inspection Tools","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-78d8.htm"},{"title": "Understanding the Trace Stack Window","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-78cb.htm"}]},
{"title":"Using the Symbol Service Dialog Box",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-78ba.htm",
"description":"The Symbol Service feature is designed to simplify access to the different debugger features provided for symbols. Most facilities available for symbols are also available through this feature.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Debugging Programs","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-5194.htm"},{"title": "Using Visual LISP Data Inspection Tools","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-78d8.htm"}]},
{"title":"Using the Symbol Service Toolbar",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-78b4.htm",
"description":"The Symbol Service toolbar contains the following buttons:",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Debugging Programs","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-5194.htm"},{"title": "Using Visual LISP Data Inspection Tools","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-78d8.htm"},{"title": "Using the Symbol Service Dialog Box","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-78ba.htm"}]},
{"title":"Understanding Symbol Flags",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-78b3.htm",
"description":"The Symbol Service dialog box provides direct access to symbol flags and properties of functional objects that may be associated with them. The following symbol flag options are available:",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Debugging Programs","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-5194.htm"},{"title": "Using Visual LISP Data Inspection Tools","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-78d8.htm"},{"title": "Using the Symbol Service Dialog Box","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-78ba.htm"}]},
{"title":"Using Inspect Windows",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-78b2.htm",
"description":"The Inspect feature is the component of VLISP that provides you with the ability to browse, examine, and modify AutoLISP and AutoCAD objects. You can use Inspect to view the following items:",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Debugging Programs","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-5194.htm"},{"title": "Using Visual LISP Data Inspection Tools","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-78d8.htm"}]},
{"title":"Using the Inspect Window",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-78ab.htm",
"description":"All Inspect windows have a similar appearance and contain a caption, an object line, and an object element list (which may be empty). The window elements contain the following content:",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Debugging Programs","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-5194.htm"},{"title": "Using Visual LISP Data Inspection Tools","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-78d8.htm"},{"title": "Using Inspect Windows","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-78b2.htm"}]},
{"title":"Understanding Object Element List Formats",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-78a7.htm",
"description":"The contents of an Inspect element list vary, depending on the data type of the object being inspected. The following table identifies the list contents for each data type.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Debugging Programs","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-5194.htm"},{"title": "Using Visual LISP Data Inspection Tools","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-78d8.htm"},{"title": "Using Inspect Windows","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-78b2.htm"}]},
{"title":"Common Inspect Commands",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7897.htm",
"description":"The Inspect windows provide shortcut menus containing commands relevant to the data being inspected.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Debugging Programs","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-5194.htm"},{"title": "Using Visual LISP Data Inspection Tools","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-78d8.htm"},{"title": "Using Inspect Windows","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-78b2.htm"}]},
{"title":"Copying Inspect Objects to the *obj* IDE Global Variable",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7896.htm",
"description":"Sometimes it is useful to access some part of an object from your program or from the VLISP Console window. You may also want to copy the value of one object\'s item into another item and so on. To perform all these tasks, the Inspect feature manages a reserved global IDE variable named *obj*. This variable can be used as a temporary storage area while browsing through data structures. From inside an Inspect dialog box, you can assign a value to this variable and replace the value of the current item with the value of *obj*.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Debugging Programs","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-5194.htm"},{"title": "Using Visual LISP Data Inspection Tools","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-78d8.htm"},{"title": "Using Inspect Windows","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-78b2.htm"}]},
{"title":"Handling Errors in the Inspect Command",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7895.htm",
"description":"In text editor windows it is not possible to inspect selected expressions longer than 256 characters. If you select a string longer than 256 characters, you will be prompted to enter an object name.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Debugging Programs","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-5194.htm"},{"title": "Using Visual LISP Data Inspection Tools","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-78d8.htm"},{"title": "Using Inspect Windows","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-78b2.htm"}]},
{"title":"Closing All Inspect Windows",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7894.htm",
"description":"To close all Inspect windows, choose Window Close Windows Inspectors from the VLISP menu.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Debugging Programs","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-5194.htm"},{"title": "Using Visual LISP Data Inspection Tools","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-78d8.htm"},{"title": "Using Inspect Windows","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-78b2.htm"}]},
{"title":"Viewing AutoCAD Drawing Entities",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7893.htm",
"description":"VLISP provides facilities to walk through the AutoCAD drawing database and inspect the raw data for each drawing entity reported by AutoCAD. You access drawing entities through the VLISP Browse Database feature. Browse Database displays entity information in Inspect windows. You can set a diagnostic option telling VLISP how much information to supply about entities.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Debugging Programs","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-5194.htm"},{"title": "Using Visual LISP Data Inspection Tools","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-78d8.htm"}]},
{"title":"Viewing Entities in the Drawing Database",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7890.htm",
"description":"To Open an Inspect window for the collection of entities in the current drawing database, choose View Browse Drawing Database Browse All Entities from the VLISP menu. VLISP displays a window listing the entities in the database:",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Debugging Programs","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-5194.htm"},{"title": "Using Visual LISP Data Inspection Tools","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-78d8.htm"},{"title": "Viewing AutoCAD Drawing Entities","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7893.htm"}]},
{"title":"Viewing Symbol Tables in the Drawing Database",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-788d.htm",
"description":"Choosing View Browse Drawing Database Browse Tables from the VLISP menu opens an Inspect window for the collection of symbol tables in your drawing:",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Debugging Programs","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-5194.htm"},{"title": "Using Visual LISP Data Inspection Tools","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-78d8.htm"},{"title": "Viewing AutoCAD Drawing Entities","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7893.htm"}]},
{"title":"Viewing Blocks in the Drawing Database",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7889.htm",
"description":"Choose View Browse Drawing Database Browse Blocks from the VLISP menu to open an Inspect window for the blocks in your drawing:",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Debugging Programs","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-5194.htm"},{"title": "Using Visual LISP Data Inspection Tools","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-78d8.htm"},{"title": "Viewing AutoCAD Drawing Entities","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7893.htm"}]},
{"title":"Viewing Selected Objects in a Drawing",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7886.htm",
"description":"Choose View Browse Drawing Database Browse Selection from the VLISP menu to select the drawing objects you want to view. VLISP invokes the ssget function to prompt you to define a selection set in the AutoCAD drawing window. When you complete the selection, VLISP opens the Inspect window for your selection:",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Debugging Programs","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-5194.htm"},{"title": "Using Visual LISP Data Inspection Tools","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-78d8.htm"},{"title": "Viewing AutoCAD Drawing Entities","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7893.htm"}]},
{"title":"Viewing Extended Data",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7884.htm",
"description":"Choose View Browse Drawing Database Inquire Extended Data from the VLISP menu to see a list of the applications currently registered (through regapp) as containing extended data. If you select an application from this list, its extended data is included into the Inspect entget list.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Debugging Programs","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-5194.htm"},{"title": "Using Visual LISP Data Inspection Tools","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-78d8.htm"},{"title": "Viewing AutoCAD Drawing Entities","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7893.htm"}]},
{"title":"Building Applications",
"href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4ed1.htm",
"description":"You can compile your program files and create a single executable module that you can distribute to users.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"}]},
{"title":"Compiling and Linking Programs",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-787f.htm",
"description":"Each time you load AutoLISP® source code, the code is translated into instructions the computer understands (executable code). The advantage of having source code translated each time you load it is that you can make a change and immediately try it out. This is useful for quickly testing new code, and for debugging that code.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Building Applications","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4ed1.htm"}]},
{"title":"Using the Compiler",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-787e.htm",
"description":"VLISP provides several ways to access and use the file compiler. To compile a single AutoLISP file, you can use the vlisp-compile function. To compile many AutoLISP files into a single VLX file, you can use the Make Application wizard. The vlisp-compile function and the Make Application wizard are described in this chapter.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Building Applications","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4ed1.htm"},{"title": "Compiling and Linking Programs","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-787f.htm"}]},
{"title":"Compiling a Program from a File",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-787d.htm",
"description":"To compile a single AutoLISP file, call the vlisp-compile function. The function syntax is",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Building Applications","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4ed1.htm"},{"title": "Compiling and Linking Programs","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-787f.htm"}]},
{"title":"Choosing a Compiler Mode",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-787b.htm",
"description":"The mode parameter indicates the compilation mode, which can be one of the following:",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Building Applications","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4ed1.htm"},{"title": "Compiling and Linking Programs","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-787f.htm"},{"title": "Compiling a Program from a File","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-787d.htm"}]},
{"title":"Identifying the Input File",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7879.htm",
"description":"If your source file is in the AutoCAD support file search path, you do not have to include the path name when specifying the file name. The search path is set by choosing Tools Options from the AutoCAD menu, then clicking the Files tab and selecting Support File Search Path:",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Building Applications","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4ed1.htm"},{"title": "Compiling and Linking Programs","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-787f.htm"},{"title": "Compiling a Program from a File","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-787d.htm"}]},
{"title":"Naming an Output File",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7877.htm",
"description":"The compiler produces code in the fast-load AutoLISP format (FAS). By default, the output file containing this code has the same name as the input file, but with an extension of .fas. You can override the default name by specifying an output file name. For example, to compile yinyang.lsp and produce an output file named GoodKarma.fas, issue the following command:",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Building Applications","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4ed1.htm"},{"title": "Compiling and Linking Programs","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-787f.htm"},{"title": "Compiling a Program from a File","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-787d.htm"}]},
{"title":"Walking through a Compile Example",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7876.htm",
"description":"You can use the yinyang.lsp file in the AutoCAD sample\visuallisp directory to exercise the vlisp-compile function.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Building Applications","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4ed1.htm"},{"title": "Compiling and Linking Programs","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-787f.htm"}]},
{"title":"Loading and Running Compiled Programs",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7872.htm",
"description":"",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Building Applications","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4ed1.htm"},{"title": "Compiling and Linking Programs","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-787f.htm"}]},
{"title":"Loading Extended AutoLISP Functions",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-786e.htm",
"description":"VLISP provides some extensions to the AutoLISP language that are not loaded automatically when you start AutoCAD. These functions have names that begin with vla-, vlax-, and vlr-. The vla- functions implement AutoLISP ActiveX® support. The vlax- functions provide ActiveX utility and data conversion functions, dictionary handling functions, and curve measurement functions. The vlr- functions provide support for AutoCAD reactors. Before you can use any of these functions, you must load the AutoLISP extensions with the following function call:",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Building Applications","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4ed1.htm"},{"title": "Compiling and Linking Programs","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-787f.htm"},{"title": "Loading and Running Compiled Programs","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7872.htm"}]},
{"title":"Linking Function Calls",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-786d.htm",
"description":"The process of compiling function calls results in VLISP creating a loadable module containing in-line copies of some AutoLISP built-in functions. In-line compilation of built-in functions increases the efficiency of the resulting code, but may change the behavior of some tricky AutoLISP programs.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Building Applications","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4ed1.htm"},{"title": "Compiling and Linking Programs","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-787f.htm"}]},
{"title":"Making Application Modules",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-786c.htm",
"description":"VLISP provides you with the ability to create a single, stand-alone executable module for your application. This module incorporates all your application\'s compiled files, and can include DCL, DVB, and other files that your application may need. Executable VLISP modules are known as VLX files, and are stored in files named with a .vlx extension.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Building Applications","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4ed1.htm"}]},
{"title":"Creating a New Application",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-786b.htm",
"description":"It is recommended you build your application only after you have fully debugged it. Compiler errors during the Make process may prevent the application wizard from completing successfully.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Building Applications","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4ed1.htm"},{"title": "Making Application Modules","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-786c.htm"}]},
{"title":"Understanding the Output from Make Application",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-785e.htm",
"description":"VLISP executes instructions in a Make file to build an application. Output messages from this process appear in two VLISP windows: the Build Output window and the Console window. The Build Output window contains messages relating to any compilation of AutoLISP source code into .fas files. In a successful compile, the output looks like the following:",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Building Applications","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4ed1.htm"},{"title": "Making Application Modules","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-786c.htm"},{"title": "Creating a New Application","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-786b.htm"}]},
{"title":"Loading and Running Visual LISP Applications",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-785a.htm",
"description":"To execute the functions in a VLX application, you must first load the VLX file using any of the following methods:",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Building Applications","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4ed1.htm"},{"title": "Making Application Modules","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-786c.htm"}]},
{"title":"Changing Application Options",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7858.htm",
"description":"VLISP allows you to change the way your application is designed. For example, you can change compilation options, or add or remove AutoLISP files from the application.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Building Applications","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4ed1.htm"},{"title": "Making Application Modules","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-786c.htm"}]},
{"title":"Rebuilding an Application",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7854.htm",
"description":"After changing application options or modifying source code, you need to rebuild your application for the changes to take effect.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Building Applications","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4ed1.htm"},{"title": "Making Application Modules","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-786c.htm"}]},
{"title":"Updating an Application",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7851.htm",
"description":"If you change just a small piece of your application\'s AutoLISP source code, you can have VLISP rebuild your application VLX while compiling only those files you\'ve updated. To make this type of update, choose File Make Application Make Application from the VLISP menu, and select your application\'s Make file. VLISP rebuilds the application based on the information contained in the Make file, and automatically compiles any application source files for which either of the following is true:",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Building Applications","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4ed1.htm"},{"title": "Making Application Modules","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-786c.htm"}]},
{"title":"Designing for a Multiple Document Environment",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-784f.htm",
"description":"Using the AutoCAD multiple document interface (MDI), users can copy objects between drawings and display several drawings side by side in a single work session. When you design an AutoCAD application, you need to understand how open drawing documents relate to one another.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Building Applications","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4ed1.htm"}]},
{"title":"Understanding Namespaces",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-784e.htm",
"description":"The concept of namespaces was introduced to prevent applications running in one drawing window from unintentionally affecting applications running in other windows. A namespace is a LISP environment containing a set of symbols (for example, variables and functions). Each open AutoCAD drawing document has its own namespace. Variables and functions defined in one document namespace are isolated from variables and functions defined in other namespaces.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Building Applications","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4ed1.htm"},{"title": "Designing for a Multiple Document Environment","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-784f.htm"}]},
{"title":"Running an Application in Its Own Namespace",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7847.htm",
"description":"You can define a namespace for a VLX application in VLISP. A VLX application defined in this manner is referred to as a separate-namespace VLX. When you load a separate-namespace VLX, it runs in its own namespace, not the namespace of the document from where you loaded the VLX. The option to define a VLX application with its own namespace is part of the Make Application procedure (see ).",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Building Applications","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4ed1.htm"},{"title": "Designing for a Multiple Document Environment","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-784f.htm"}]},
{"title":"Accessing External ObjectARX Functions from a Separate-Namespace VLX",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7845.htm",
"description":"In order to access functions that are defined in an external ObjectARX application from a separate-namespace VLX, you must first issue vl-arx-import to import the function. ObjectARX functions are identified as data type EXRXSUBR. For example, the following command identifies startapp as an external ObjectARX function:",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Building Applications","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4ed1.htm"},{"title": "Designing for a Multiple Document Environment","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-784f.htm"},{"title": "Running an Application in Its Own Namespace","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7847.htm"}]},
{"title":"Making Functions Available to Documents",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7844.htm",
"description":"By default, functions defined in a separate-namespace VLX are not exposed to the document namespace from which the VLX is loaded. You must use the vl-doc-export function to expose functions to document namespaces. When issued from a VLX that runs in its own namespace, vl-doc-export exposes the specified function to any document namespace that loads the VLX. The vl-doc-export function accepts a single argument, a symbol identifying the function name. For example, look at the following code:",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Building Applications","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4ed1.htm"},{"title": "Designing for a Multiple Document Environment","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-784f.htm"},{"title": "Running an Application in Its Own Namespace","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7847.htm"}]},
{"title":"Making Separate-Namespace Functions Available to Other VLX Applications",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7840.htm",
"description":"Functions defined in one separate-namespace VLX are not exposed to any other separate-namespace VLX applications. If a function has been exported through vl-doc-export, you can use the vl-doc-import function to make the function available to another separate-namespace VLX.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Building Applications","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4ed1.htm"},{"title": "Designing for a Multiple Document Environment","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-784f.htm"},{"title": "Running an Application in Its Own Namespace","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7847.htm"}]},
{"title":"Referencing Variables in Document Namespaces",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-783f.htm",
"description":"Variables defined in a separate-namespace VLX are not known to the document namespace associated with the VLX. However, a separate-namespace VLX can access variables defined in a document namespace using the vl-doc-ref and vl-doc-set functions.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Building Applications","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4ed1.htm"},{"title": "Designing for a Multiple Document Environment","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-784f.htm"},{"title": "Running an Application in Its Own Namespace","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7847.htm"}]},
{"title":"Sharing Data Between Namespaces",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-783e.htm",
"description":"VLISP provides a blackboard namespace for communicating the values of variables between namespaces. The blackboard is a namespace that is not attached to any document or VLX application. You can set and reference variables in the blackboard from any document or VLX. Use the vl-bb-set function to set a variable, and use vl-bb-ref to retrieve a variable\'s value.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Building Applications","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4ed1.htm"},{"title": "Designing for a Multiple Document Environment","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-784f.htm"}]},
{"title":"Handling Errors in an MDI Environment",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-783b.htm",
"description":"By default, each document namespace is provided with its own *error* function, which is defined as follows:",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Building Applications","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4ed1.htm"},{"title": "Designing for a Multiple Document Environment","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-784f.htm"}]},
{"title":"Handling Errors in a VLX Application Running in Its Own Namespace",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-783a.htm",
"description":"For VLX applications executing within their own namespace, you can either use the default error function or you can define an error handler specifically for the application.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Building Applications","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4ed1.htm"},{"title": "Designing for a Multiple Document Environment","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-784f.htm"},{"title": "Handling Errors in an MDI Environment","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-783b.htm"}]},
{"title":"Limitations on Using AutoLISP in an MDI Environment",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7839.htm",
"description":"When using native AutoLISP in an MDI environment, you can only work with one drawing document at a time. Although AutoLISP provides support for exchanging variables and exposing functions to multiple namespaces, you cannot, for example, run a function in one document namespace and issue entmake to create an entity in another document namespace. AutoLISP does not support accessing information across multiple drawings.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Building Applications","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4ed1.htm"},{"title": "Designing for a Multiple Document Environment","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-784f.htm"}]},
{"title":"Maintaining Visual LISP Applications",
"href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4d8b.htm",
"description":"You can maintain large programs by creating a Visual LISP project and optimizing code.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"}]},
{"title":"Managing Multiple LISP Files",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7bc3.htm",
"description":"Many program examples you have seen in this document have been small, stand-alone AutoLISP® files. Typical AutoLISP applications, however, consist of larger files with many lines of code. An application may include many source code files. After compiling the programs in such an application, you also have a number of FAS files to track.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Maintaining Visual LISP Applications","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4d8b.htm"}]},
{"title":"Understanding Visual LISP Projects",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7bc2.htm",
"description":"To aid you in the process of maintaining multiple-file applications, VLISP provides a construct called a project. A VLISP project contains a list of AutoLISP source files, and a set of rules on how to compile the files. Using the project definition, VLISP can do the following:",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Maintaining Visual LISP Applications","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4d8b.htm"},{"title": "Managing Multiple LISP Files","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7bc3.htm"}]},
{"title":"LISP, FAS, and Other File Types",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7bc0.htm",
"description":"The basic file type in VLISP is the AutoLISP source file. Typically, AutoLISP source files are named with an .lsp file extension. You have seen .lsp files used frequently in previous chapters.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Maintaining Visual LISP Applications","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4d8b.htm"},{"title": "Managing Multiple LISP Files","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7bc3.htm"},{"title": "Understanding Visual LISP Projects","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7bc2.htm"}]},
{"title":"Defining a Project",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7bbd.htm",
"description":"To demonstrate the use of projects in VLISP, you can use the sample programs supplied with the AutoLISP Tutorial. This code is available on the AutoCAD® installation CD, but the tutorial files are only included in your installation if you choose a Full install, or if you choose Custom install and select the Tutorials item. If you have already installed AutoCAD and did not install the samples, you can rerun the installation, choose Custom, and select only the Tutorials item.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Maintaining Visual LISP Applications","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4d8b.htm"}]},
{"title":"Assigning Project Properties",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7bbb.htm",
"description":"The Project Properties dialog box is displayed after you specify a project file name.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Maintaining Visual LISP Applications","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4d8b.htm"},{"title": "Defining a Project","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7bbd.htm"}]},
{"title":"Selecting the Files to Include in a Project",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7bba.htm",
"description":"There are two tabs in the Project Properties dialog box. In the Project Files tab, you specify the AutoLISP source files for the project.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Maintaining Visual LISP Applications","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4d8b.htm"},{"title": "Defining a Project","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7bbd.htm"},{"title": "Assigning Project Properties","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7bbb.htm"}]},
{"title":"Identifying the Path Name of Project Files",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7bb5.htm",
"description":"The list of included files does not identify the path name of each file (nor does the Look In field; this just identifies the path of the files listed in the left window). Because you can include files from multiple directories in your project, you need to be able to identify the path name of each file. You can do this by highlighting one or more file names and right-clicking to display a shortcut menu:",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Maintaining Visual LISP Applications","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4d8b.htm"},{"title": "Defining a Project","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7bbd.htm"},{"title": "Assigning Project Properties","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7bbb.htm"}]},
{"title":"Changing the Order in Which Visual LISP Loads Files",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7bb2.htm",
"description":"The shortcut menu for the list of included files also provides commands to move files up and down in the list, and to sort the list by file name or by full path name. VLISP loads the project\'s files in the order in which they are listed. Sometimes the load order is important. For example, you might have an initialization file that defines global variables needed by all the other program files, and thus must be loaded first. You could select that file name and choose Move to Top to place it first in the project\'s file list.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Maintaining Visual LISP Applications","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4d8b.htm"},{"title": "Defining a Project","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7bbd.htm"},{"title": "Assigning Project Properties","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7bbb.htm"}]},
{"title":"Choosing Compiler Build Options",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7bb1.htm",
"description":"The Build Options tab displays a dialog box in which you can specify compiler options to VLISP. This topic is covered in the section later in this chapter. For now, choose OK to close the Project Properties dialog box.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Maintaining Visual LISP Applications","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4d8b.htm"},{"title": "Defining a Project","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7bbd.htm"},{"title": "Assigning Project Properties","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7bbb.htm"}]},
{"title":"Using the Project Window to Work with Project Files",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7bb0.htm",
"description":"When you open a VLISP project, VLISP displays a window listing the files in the project:",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Maintaining Visual LISP Applications","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4d8b.htm"},{"title": "Defining a Project","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7bbd.htm"}]},
{"title":"Selecting Multiple Project Members",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7bae.htm",
"description":"The Multiple Selector menu item is available only from the Project Properties dialog box shortcut menu. Choosing this option allows you to select multiple members from the list in the Project window. If the option is selected, a check mark appears next to the Multiple Selector item on the menu. Click on the menu item to toggle it on and off.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Maintaining Visual LISP Applications","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4d8b.htm"},{"title": "Defining a Project","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7bbd.htm"},{"title": "Using the Project Window to Work with Project Files","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7bb0.htm"}]},
{"title":"Loading Project Files",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7bab.htm",
"description":"To load the project\'s compiled program files, click the Load Project FAS button. This allows you to run the application. If VLISP detects that some of the source files do not exist in compiled format, it displays a message and asks if you want to compile those files:",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Maintaining Visual LISP Applications","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4d8b.htm"},{"title": "Defining a Project","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7bbd.htm"},{"title": "Using the Project Window to Work with Project Files","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7bb0.htm"}]},
{"title":"Compiling and Recompiling Project Files",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7ba9.htm",
"description":"One key advantage in defining VLISP projects for your applications is that it provides an efficient method of updating compiled code. You can elect to have VLISP recompile all source files that have changed since the last time they were compiled. By choosing this option, you ensure all FAS files in your application correspond to the latest versions of the program source code. At the same time, you save time by avoiding unnecessary compiles. To invoke this feature, click the Build Project FAS button in the Project Properties dialog box.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Maintaining Visual LISP Applications","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4d8b.htm"},{"title": "Defining a Project","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7bbd.htm"},{"title": "Using the Project Window to Work with Project Files","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7bb0.htm"}]},
{"title":"Editing Project Files",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7ba8.htm",
"description":"To edit the source file of a project member, select the member from the list in the Project window, then right-click and choose Edit. If the Multiple Selector option is on, you can select multiple members, and VLISP will open a text editor window for each.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Maintaining Visual LISP Applications","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4d8b.htm"},{"title": "Defining a Project","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7bbd.htm"},{"title": "Using the Project Window to Work with Project Files","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7bb0.htm"}]},
{"title":"Saving and Closing the Project",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7ba7.htm",
"description":"To save the project properties you defined or modified, right-click in the Project window and choose Save Project As from the shortcut menu. VLISP displays a list of project files. You can either select the name of the current project file to update its contents, or enter a new file name to save the changes as a new project.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Maintaining Visual LISP Applications","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4d8b.htm"},{"title": "Defining a Project","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7bbd.htm"},{"title": "Using the Project Window to Work with Project Files","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7bb0.htm"}]},
{"title":"Working with Existing Projects",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7ba6.htm",
"description":"Some VLISP features described in previous chapters have special application with VLISP projects. The features described in this section are the text editor search functions and the Make Application wizard.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Maintaining Visual LISP Applications","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4d8b.htm"}]},
{"title":"Opening a Project",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7ba5.htm",
"description":"To open an existing project, choose Project Open Project from the VLISP menu:",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Maintaining Visual LISP Applications","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4d8b.htm"},{"title": "Working with Existing Projects","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7ba6.htm"}]},
{"title":"Finding a String in Project Source Files",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7ba2.htm",
"description":"The VLISP text search function, described in , provides you with the ability to search all of a project\'s source files for a string of text.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Maintaining Visual LISP Applications","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4d8b.htm"},{"title": "Working with Existing Projects","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7ba6.htm"}]},
{"title":"Including a Project in a Visual LISP Application",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b9f.htm",
"description":"After you\'ve made changes to an application\'s source files, you\'ll want to incorporate those changes in the application\'s executable file. showed you how to keep individual application files synchronized, so that the application executable contained the latest versions of all its source files. Defining the application files as members of a single project simplifies this process further. Instead of listing every source file in your application\'s Make file, you can point to the VLISP project file and use the project file to identify your source files.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Maintaining Visual LISP Applications","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4d8b.htm"},{"title": "Working with Existing Projects","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7ba6.htm"}]},
{"title":"Optimizing Application Code",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b9c.htm",
"description":"The optimization features of VLISP can produce more efficient compiled files, and are useful as your programs grow in size and complexity. With the VLISP project management feature, you can tailor the optimization options to the specific needs of your application.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Maintaining Visual LISP Applications","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4d8b.htm"}]},
{"title":"Defining Build Options",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b9b.htm",
"description":"VLISP provides a number of options for compiling and linking a project\'s source code that affect the efficiency of the compiled code. For example, you can specify whether to create a separate FAS file for each source file or merge all compiled files into a single FAS file. You can choose to have the compiler remove the names of all local symbols from your compiled files. You specify these options in the Project Properties dialog box.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Maintaining Visual LISP Applications","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4d8b.htm"},{"title": "Optimizing Application Code","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b9c.htm"}]},
{"title":"Choosing a Compilation Mode",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b95.htm",
"description":"Combining compiled code from multiple files to a single binary file allows the compiler to add a high level of optimization. It also means that there are more choices to make.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Maintaining Visual LISP Applications","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4d8b.htm"},{"title": "Optimizing Application Code","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b9c.htm"}]},
{"title":"Analyzing for Optimization Correctness",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b94.htm",
"description":"Optimizing code may introduce bugs to software that runs perfectly when non-optimized. Also, the level of performance gain depends highly on the internal structure of the source code. LISP is a language in which you can easily write programs that create or modify functions at runtime. This use of the language by definition contradicts compile-time optimization.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Maintaining Visual LISP Applications","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4d8b.htm"},{"title": "Optimizing Application Code","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b9c.htm"},{"title": "Choosing a Compilation Mode","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b95.htm"}]},
{"title":"Choosing a Link Mode",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b91.htm",
"description":"If you instruct the VLISP compiler to link functions in your project directly, the compiler tries to resolve all explicit function calls by referencing the function\'s definition in memory. In contrast, when you indirectly link your functions, the compiler creates references to symbols that VLISP later uses to look up the actual memory location of the function. Direct linking improves the performance of the compiled code and protects the code against function redefinition. However, if your application needs to redefine a function, you cannot directly link that function.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Maintaining Visual LISP Applications","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4d8b.htm"},{"title": "Optimizing Application Code","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b9c.htm"}]},
{"title":"Understanding Safe Optimization",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b90.htm",
"description":"Choosing the Safe Optimize option reduces the amount of compiler optimization but protects your code against compiler-induced errors. Safe optimizing prevents runtime uncertainty that could cause an optimized program to fail, even though the source code seems to be correct. For example, imagine the following situation:",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Maintaining Visual LISP Applications","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4d8b.htm"},{"title": "Optimizing Application Code","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b9c.htm"}]},
{"title":"Optimization Conditions Bypassed by Safe Optimization",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b8e.htm",
"description":"When Safe Optimization is in effect, the VLISP compiler ignores an optimization option if it determines that adhering to the option may induce an error condition. The following list identifies the conditions under which an option is ignored:",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Maintaining Visual LISP Applications","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4d8b.htm"},{"title": "Optimizing Application Code","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b9c.htm"},{"title": "Understanding Safe Optimization","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b90.htm"}]},
{"title":"Safe Optimization Warning Messages",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b8b.htm",
"description":"If optimized compilation is on and the compiler finds a condition that forbids a certain level of optimization, it issues a warning message. For example, if the function fishlips cannot be linked because the compiler found two definitions for the function, you\'ll see:",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Maintaining Visual LISP Applications","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4d8b.htm"},{"title": "Optimizing Application Code","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b9c.htm"},{"title": "Understanding Safe Optimization","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b90.htm"}]},
{"title":"Compiler Checking of Optimizing Conditions",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b8a.htm",
"description":"The compiler always checks for optimizing consistency. If you specify an optimization option that contradicts certain security rules, the compiler will issue warning messages. The security rules are:",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Maintaining Visual LISP Applications","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4d8b.htm"},{"title": "Optimizing Application Code","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b9c.htm"},{"title": "Understanding Safe Optimization","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b90.htm"}]},
{"title":"Working with ActiveX",
"href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-7c71.htm",
"description":"With Visual LISP, you can access the AutoCAD object model.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"}]},
{"title":"Using ActiveX Objects with AutoLISP",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c12.htm",
"description":"ActiveX Automation is a way to work programmatically with the contents of an AutoCAD® drawing. In many instances, ActiveX works faster than traditional AutoLISP functions in manipulating AutoCAD drawing objects.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Working with ActiveX","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-7c71.htm"}]},
{"title":"Understanding the AutoCAD Object Model",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c10.htm",
"description":"AutoCAD objects are structured in a hierarchical fashion, with the Application object at the root. The view of this hierarchical structure is referred to as the object model. It shows you which object provides access to the next level of objects. The AutoCAD object model is described in the following figure:",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Working with ActiveX","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-7c71.htm"}]},
{"title":"Object Properties",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c0e.htm",
"description":"All objects in the AutoCAD object model have one or more properties. For example, a circle object can be described by properties such as radius, area, or linetype. An ellipse object also has area and linetype properties, but it cannot be described in terms of its radius. Rather, you describe it in terms of its major to minor axis ratio, a property named RadiusRatio. Property names are necessary when accessing AutoCAD data through ActiveX functions.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Working with ActiveX","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-7c71.htm"},{"title": "Understanding the AutoCAD Object Model","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c10.htm"}]},
{"title":"Object Methods",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c0d.htm",
"description":"ActiveX objects also contain methods, which are simply the actions available for a particular kind of object. Some methods can be applied to most AutoCAD drawing objects. For example, the Mirror method (creating a mirror image copy of an object around a mirror axis), and the Move method (moving a drawing object along a specified vector) can be applied to most drawing objects. By contrast, the Offset method, which creates a new object at a specified distance from an existing object, applies only to a few classes of AutoCAD objects such as Arc, Circle, Ellipse, and Line.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Working with ActiveX","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-7c71.htm"},{"title": "Understanding the AutoCAD Object Model","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c10.htm"}]},
{"title":"Collections of Objects",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c0c.htm",
"description":"All objects in the AutoCAD object model are grouped in collections. For example, the Blocks collection is made up of all blocks in an AutoCAD drawing, and the ModelSpace collection comprises all graphical objects (circles, lines, polylines, and so on) in the drawing\'s model space. Collections are labeled in the object model diagram.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Working with ActiveX","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-7c71.htm"},{"title": "Understanding the AutoCAD Object Model","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c10.htm"}]},
{"title":"Accessing AutoCAD Objects",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c0b.htm",
"description":"The Application object is the root object for the AutoCAD object model. From the Application object, you can access any of the other objects, or the properties or methods assigned to objects.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Working with ActiveX","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-7c71.htm"}]},
{"title":"Using the Inspect Tool to View Object Properties",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c0a.htm",
"description":"To view the properties associated with an Application object, you can select the variable that points to the object (acadobject, in the previous example), and choose the Inspect button on the VLISP View toolbar as follows:",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Working with ActiveX","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-7c71.htm"},{"title": "Accessing AutoCAD Objects","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c0b.htm"}]},
{"title":"Moving Forward from the Application Object",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c05.htm",
"description":"Following the AutoCAD object model hierarchy, the ActiveDocument property of the Application object leads you to a Document object. This Document object represents the current AutoCAD drawing. The following AutoLISP command returns the active document:",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Working with ActiveX","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-7c71.htm"},{"title": "Accessing AutoCAD Objects","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c0b.htm"}]},
{"title":"Summarizing the Process",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c04.htm",
"description":"In this section, you saw code examples that led to the drawing of a circle object in an AutoCAD drawing using ActiveX Automation. The following sequence of function calls was used:",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Working with ActiveX","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-7c71.htm"},{"title": "Accessing AutoCAD Objects","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c0b.htm"}]},
{"title":"Performance Considerations",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c01.htm",
"description":"Repeated calls to access the AutoCAD Application, active Document, and ModelSpace objects should be avoided, as they negatively impact performance. You should design your applications to obtain these objects one time, and refer to the obtained object pointers throughout the application.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Working with ActiveX","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-7c71.htm"},{"title": "Accessing AutoCAD Objects","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c0b.htm"}]},
{"title":"Using Visual LISP Functions with ActiveX Methods",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c00.htm",
"description":"VLISP adds a set of functions to the AutoLISP language that provides access to ActiveX objects. The function names are prefixed with vla-: for example, vla-addCircle, vla-get-ModelSpace, vla-getColor. These functions can be further categorized as follows:",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Working with ActiveX","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-7c71.htm"}]},
{"title":"Determining the Visual LISP Function You Need",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7bfe.htm",
"description":"The VLISP ActiveX functions actually provide access to ActiveX methods. For example, look at the following AutoLISP statement, which was entered at the VLISP Console prompt:",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Working with ActiveX","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-7c71.htm"},{"title": "Using Visual LISP Functions with ActiveX Methods","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c00.htm"}]},
{"title":"Determining How to Call a Function",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7bfc.htm",
"description":"Once you identify the VLISP function you need, you still must determine how to call the function. You need to know the arguments to specify and the data type of those arguments. The ActiveX and VBA Reference contains the information required for coding calls to ActiveX functions.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Working with ActiveX","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-7c71.htm"},{"title": "Using Visual LISP Functions with ActiveX Methods","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c00.htm"}]},
{"title":"Converting AutoLISP Data Types to ActiveX Data Types",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7bfa.htm",
"description":"When adding a circle to a drawing, you must specify the center point of the circle and the radius of the circle. In the definition for the AddCircle method in the ActiveX and VBA Reference, these arguments are referred to as Center and Radius. Center is defined as a variant (three-element array of doubles), and Radius is listed as a double:",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Working with ActiveX","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-7c71.htm"},{"title": "Using Visual LISP Functions with ActiveX Methods","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c00.htm"}]},
{"title":"Working with Variants",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7bf8.htm",
"description":"Several AutoLISP functions allow you to create and work with variants:",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Working with ActiveX","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-7c71.htm"},{"title": "Using Visual LISP Functions with ActiveX Methods","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c00.htm"},{"title": "Converting AutoLISP Data Types to ActiveX Data Types","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7bfa.htm"}]},
{"title":"Working with Safearrays",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7bf6.htm",
"description":"Arrays passed to ActiveX methods must be of the safearray type. These arrays are safe because you cannot accidentally assign values outside the array bounds and cause a data exception to occur. Use the vlax-make-safearray function to create a safearray and use vlax-safearray-put-element or vlax-safearray-fill to populate a safearray with data.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Working with ActiveX","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-7c71.htm"},{"title": "Using Visual LISP Functions with ActiveX Methods","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c00.htm"},{"title": "Converting AutoLISP Data Types to ActiveX Data Types","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7bfa.htm"}]},
{"title":"Using Safearrays with Variants",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7bf2.htm",
"description":"Safearray data must be passed to ActiveX methods through variants. That is, you create a safearray, then you assign the safearray to a variant before passing it to a method. For methods that require you to pass a three-element array of doubles (typically to specify a point), you can use the vlax-3d-point function to build the required data structure. For example, the following call takes a list of points and converts the list into an array of three doubles:",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Working with ActiveX","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-7c71.htm"},{"title": "Using Visual LISP Functions with ActiveX Methods","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c00.htm"},{"title": "Converting AutoLISP Data Types to ActiveX Data Types","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7bfa.htm"}]},
{"title":"Converting Other AutoLISP Data Types for ActiveX Methods",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7bef.htm",
"description":"The Radius argument to the AddCircle method requires a Double, but the ActiveX functions make the necessary conversion if you specify a real in AutoLISP. The following table identifies the AutoLISP data type that ActiveX functions will accept in place of the required ActiveX data type. Each row in the table represents a data type used by ActiveX functions. Each column in the table represents an AutoLISP data type. Wherever the intersecting cells contain a plus (+) symbol, you can specify the corresponding AutoLISP data type for the required ActiveX data type.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Working with ActiveX","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-7c71.htm"},{"title": "Using Visual LISP Functions with ActiveX Methods","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c00.htm"},{"title": "Converting AutoLISP Data Types to ActiveX Data Types","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7bfa.htm"}]},
{"title":"Viewing and Updating Object Properties",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7bed.htm",
"description":"VLISP provides AutoLISP functions for reading and updating object properties. You can use these functions to obtain the properties of existing drawing objects (for example, the center point of a circle), and to modify drawing objects (for example, moving the center point of the circle).",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Working with ActiveX","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-7c71.htm"},{"title": "Using Visual LISP Functions with ActiveX Methods","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c00.htm"}]},
{"title":"Reading Object Properties",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7bec.htm",
"description":"Functions that read object properties are named with a vla-get prefix and require the following syntax:",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Working with ActiveX","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-7c71.htm"},{"title": "Using Visual LISP Functions with ActiveX Methods","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c00.htm"},{"title": "Viewing and Updating Object Properties","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7bed.htm"}]},
{"title":"Updating Object Properties",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7be8.htm",
"description":"Functions that update properties are prefixed with vla-put and use the following syntax:",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Working with ActiveX","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-7c71.htm"},{"title": "Using Visual LISP Functions with ActiveX Methods","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c00.htm"},{"title": "Viewing and Updating Object Properties","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7bed.htm"}]},
{"title":"Determining Whether an Object Is Available for Updating",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7be4.htm",
"description":"If other applications are working with any AutoCAD objects at the same time as your program, those objects may not be accessible. This is especially important to look out for if your application includes reactors, because reactors execute code segments in response to external events that cannot be predicted in advance (see ). Even a simple thing such as a locked layer can prevent you from changing an object\'s properties.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Working with ActiveX","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-7c71.htm"},{"title": "Using Visual LISP Functions with ActiveX Methods","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c00.htm"},{"title": "Viewing and Updating Object Properties","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7bed.htm"}]},
{"title":"Using ActiveX Methods That Return Values in Arguments",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7be2.htm",
"description":"Some ActiveX methods require that you supply them with variables into which the methods can place values. The GetBoundingBox method is an example of this type of method. Here is how it is defined in the ActiveX and VBA Reference:",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Working with ActiveX","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-7c71.htm"},{"title": "Using Visual LISP Functions with ActiveX Methods","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c00.htm"}]},
{"title":"Listing an Object\'s Properties and Methods",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7be0.htm",
"description":"Earlier in this chapter, you learned how to use the VLISP Inspect tool to display an object\'s properties. Another way to view an object\'s properties is to call the vlax-dump-object function. You can invoke this function from the VLISP Console window or from an application program. The vlax-dump-object function prints a list of the properties of the specified object and returns T. For example, the following code obtains the last object added to the model space, then issues vlax-dumpObject to print the object\'s properties:",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Working with ActiveX","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-7c71.htm"},{"title": "Using Visual LISP Functions with ActiveX Methods","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c00.htm"}]},
{"title":"Determining If a Method or Property Applies to an Object",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7bdf.htm",
"description":"Trying to use a method that does not apply to the specified object will result in an error. Trying to reference a property that does not apply to an object also results in an error. In instances where you are not sure what applies, use the vlax-method-applicable-p and vlax-property-available-p functions to test the objects. These functions return T if the method or property is available for the object, and nil if it is not.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Working with ActiveX","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-7c71.htm"},{"title": "Using Visual LISP Functions with ActiveX Methods","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c00.htm"},{"title": "Listing an Object\'s Properties and Methods","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7be0.htm"}]},
{"title":"Working with Collection Objects",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7bde.htm",
"description":"The concept of collections was introduced in Recall that all ActiveX objects in the AutoCAD object model are grouped in collections. For example, the Blocks collection is made up of all blocks in an AutoCAD document. VLISP provides functions to help you work with collections of AutoCAD objects. These functions are vlax-map-collection and vlax-for.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Working with ActiveX","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-7c71.htm"},{"title": "Using Visual LISP Functions with ActiveX Methods","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c00.htm"}]},
{"title":"Retrieving Member Objects in a Collection",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7bdd.htm",
"description":"The Item method retrieves a member object from a collection. The Count property shows the number of items in a collection. Using the Item method and Count property, you can individually process each object in a collection. For example, you can look at each object in a model space, determine the type of object, and process only the types of objects you are interested in. The following code prints the start angle for each arc object in a model space:",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Working with ActiveX","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-7c71.htm"},{"title": "Using Visual LISP Functions with ActiveX Methods","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c00.htm"},{"title": "Working with Collection Objects","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7bde.htm"}]},
{"title":"Releasing Objects and Freeing Memory",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7bdc.htm",
"description":"Just as you can have different variables pointing to the same AutoCAD entity, you can have multiple VLA-objects pointing to the same drawing object. You can compare two VLA-objects with the equal function, which returns T if both objects point to the same drawing object.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Working with ActiveX","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-7c71.htm"},{"title": "Using Visual LISP Functions with ActiveX Methods","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c00.htm"}]},
{"title":"Converting Object References",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7bdb.htm",
"description":"There are a number of ways to refer to AutoCAD drawing objects with AutoLISP. These include the following:",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Working with ActiveX","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-7c71.htm"},{"title": "Using Visual LISP Functions with ActiveX Methods","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c00.htm"}]},
{"title":"Converting between Enames and VLA-objects",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7bd9.htm",
"description":"The vlax-ename->vla-object function allows you to convert entity names (enames) obtained through functions, such as entget, to VLA-objects you can use with ActiveX functions. For example, the following code sets a variable to an ename, then uses vlax-ename->vla-object to convert the ename to a VLA-object:",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Working with ActiveX","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-7c71.htm"},{"title": "Using Visual LISP Functions with ActiveX Methods","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c00.htm"},{"title": "Converting Object References","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7bdb.htm"}]},
{"title":"Obtaining One Object Identifier from Another",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7bd8.htm",
"description":"You may find the same drawing object represented by different identifiers and data types such as a handle string, an ename, a VLA-object, or an ObjectARX object ID integer. To obtain the identifier with the data type your program requires, use the following strategies:",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Working with ActiveX","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-7c71.htm"},{"title": "Using Visual LISP Functions with ActiveX Methods","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c00.htm"},{"title": "Converting Object References","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7bdb.htm"}]},
{"title":"Handling Errors Returned by ActiveX Methods",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7bd6.htm",
"description":"When ActiveX methods fail, they raise exceptions rather than returning error values that your program can interpret. If your program uses ActiveX methods, you must prepare it to catch exceptions, otherwise the program halts, leaving the user at a Command prompt. You can use vl-catch-all-apply to intercept errors returned by ActiveX methods.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Working with ActiveX","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-7c71.htm"},{"title": "Using Visual LISP Functions with ActiveX Methods","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c00.htm"}]},
{"title":"Using ActiveX to Interact with Other Applications",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7bd3.htm",
"description":"The power of ActiveX extends beyond the ability to interact with standard AutoCAD objects. Visual LISP provides AutoLISP functions that allow you to access objects from other applications that support ActiveX. For example, you can open a Microsoft® Word document, retrieve text data from an AutoCAD drawing, and copy the text into the Word document. Or you might access cells in a Microsoft Excel spreadsheet and use the data with your AutoCAD drawing.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Working with ActiveX","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-7c71.htm"}]},
{"title":"Importing a Type Library",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7bd2.htm",
"description":"VLISP provides an AutoLISP function that allows you to import the type library of the ActiveX application you want to access. When you import a type library, AutoCAD creates a set of wrapper functions that provide access to the application\'s methods and properties. In fact, the vla- functions you have seen so far are wrapper functions created for the AutoCAD type library.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Working with ActiveX","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-7c71.htm"},{"title": "Using ActiveX to Interact with Other Applications","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7bd3.htm"}]},
{"title":"Coding Hints for Using vlax-import-type-library",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7bd1.htm",
"description":"In AutoCAD, vlax-import-type-library is executed at runtime rather than at compiletime. The following practices are recommended when using vlax-import-type-library:",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Working with ActiveX","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-7c71.htm"},{"title": "Using ActiveX to Interact with Other Applications","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7bd3.htm"},{"title": "Importing a Type Library","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7bd2.htm"}]},
{"title":"Establishing a Connection to an Application",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7bcf.htm",
"description":"If an instance of Microsoft Word is already running on your PC, use vlax-get-object to establish a connection to the application. For example, the following function call establishes a connection to a Microsoft Word application, and saves a pointer to the application in a variable named msw:",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Working with ActiveX","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-7c71.htm"},{"title": "Using ActiveX to Interact with Other Applications","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7bd3.htm"}]},
{"title":"Coding a Sample Application",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7bce.htm",
"description":"After accessing the application object, the remaining AutoLISP code is specific to the application you\'re working with and the tasks you want to accomplish. For example, the following function call accesses the documents collection object in Microsoft Word:",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Working with ActiveX","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-7c71.htm"},{"title": "Using ActiveX to Interact with Other Applications","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7bd3.htm"}]},
{"title":"Using ActiveX without Importing a Type Library",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7bcb.htm",
"description":"Importing an application type library and using the resulting ActiveX wrapper functions is convenient and provides access to VLISP features such as Apropos, but it comes at a cost. Applications such as Microsoft Word and Microsoft Excel contain hundreds of methods and properties, and creating wrappers for each of these adds up to significant memory usage. Also, you may need to use an ActiveX property or method for which there is no generated AutoLISP wrapper function. In this instance, and to avoid the overhead involved in importing a type library, VLISP provides the following AutoLISP functions:",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Working with ActiveX","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-7c71.htm"},{"title": "Using ActiveX to Interact with Other Applications","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7bd3.htm"}]},
{"title":"Calling an ActiveX Method with vlax-invoke-method",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7bc9.htm",
"description":"",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Working with ActiveX","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-7c71.htm"},{"title": "Using ActiveX to Interact with Other Applications","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7bd3.htm"},{"title": "Using ActiveX without Importing a Type Library","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7bcb.htm"}]},
{"title":"Obtaining an ActiveX Property with vlax-get-property",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7bc7.htm",
"description":"The vlax-get-property function returns the property of an object. The function requires the following arguments:",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Working with ActiveX","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-7c71.htm"},{"title": "Using ActiveX to Interact with Other Applications","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7bd3.htm"},{"title": "Using ActiveX without Importing a Type Library","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7bcb.htm"}]},
{"title":"Updating an ActiveX Property with vlax-put-property",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7bc5.htm",
"description":"The vlax-put-property function updates the property of an object. The function requires the following arguments:",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Working with ActiveX","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-7c71.htm"},{"title": "Using ActiveX to Interact with Other Applications","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7bd3.htm"},{"title": "Using ActiveX without Importing a Type Library","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7bcb.htm"}]},
{"title":"Advanced Topics",
"href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4bec.htm",
"description":"You can use reactors for event notification.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"}]},
{"title":"Attaching Reactors to AutoCAD Drawings",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c34.htm",
"description":"A reactor is an object you attach to AutoCAD drawing objects to have AutoCAD notify your application when events you are interested in occur. For example, if a user moves an entity that your application has attached a reactor to, your application will receive notification that the entity has moved. If you design it to do so, your application can react to this notification with appropriate actions, such as moving other entities associated with the one moved, or perhaps updating a text tag that records revision information on the altered drawing feature.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Advanced Topics","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4bec.htm"}]},
{"title":"Understanding Reactor Types and Events",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c33.htm",
"description":"There are many types of AutoCAD reactors. Each reactor type responds to one or more AutoCAD events. The different types of reactors are grouped into the following categories:",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Advanced Topics","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4bec.htm"},{"title": "Attaching Reactors to AutoCAD Drawings","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c34.htm"}]},
{"title":"Reactor Callback Events",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c30.htm",
"description":"For each reactor type there are a number of events that can cause the reactor to notify your application. These events are known as callback events, because they cause the reactor to call a function you associate with the event. For example, when you issue the Save command to save a drawing, a :vlr-beginSave event occurs. When you complete the save process, a :vlr-saveComplete event occurs. In designing a reactor-based application, it is up to you to determine the events you are interested in, and to write the callback functions to be triggered when these events occur.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Advanced Topics","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4bec.htm"},{"title": "Attaching Reactors to AutoCAD Drawings","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c34.htm"},{"title": "Understanding Reactor Types and Events","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c33.htm"}]},
{"title":"Defining Callback Functions",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c2f.htm",
"description":"To add reactor functionality to your application, you first need to write a callback function that performs the tasks needed at the time of the reactor event. After you define a callback function, you link the function to an event by creating a reactor object.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Advanced Topics","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4bec.htm"},{"title": "Attaching Reactors to AutoCAD Drawings","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c34.htm"}]},
{"title":"Defining Object Reactor Callback Functions",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c2c.htm",
"description":"Unlike other AutoCAD reactors, object reactors are attached to specific AutoCAD entities (objects). When you define an object reactor, you must identify the entity the reactor is to be attached to. So callback functions for object reactors must be defined to accept three arguments:",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Advanced Topics","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4bec.htm"},{"title": "Attaching Reactors to AutoCAD Drawings","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c34.htm"},{"title": "Defining Callback Functions","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c2f.htm"}]},
{"title":"Creating Reactors",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c2a.htm",
"description":"You link a callback function to an event when you create a reactor. There is an AutoLISP function for creating each type of reactor. These functions have the same name as the reactor type, minus the leading colon. For example, vlr-acdb-reactor creates a database reactor, vlr-toolbar-reactor creates a toolbar reactor, and so on. Except for object reactors, the reactor creation functions require the following arguments:",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Advanced Topics","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4bec.htm"},{"title": "Attaching Reactors to AutoCAD Drawings","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c34.htm"}]},
{"title":"Using Object Reactors",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c28.htm",
"description":"Unlike other AutoCAD reactors, object reactors are attached to specific AutoCAD entities (objects). When you define an object reactor, you must identify the entity to which the reactor is to be attached. The vlr-object-reactor function, which creates object reactors, requires the following arguments:",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Advanced Topics","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4bec.htm"},{"title": "Attaching Reactors to AutoCAD Drawings","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c34.htm"},{"title": "Creating Reactors","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c2a.htm"}]},
{"title":"Attaching Data to Reactor Objects",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c24.htm",
"description":"The object reactor creation example in included a string, “Circle Reactor,” in the call to vlr-object-reactor. You do not have to specify any data to be included with the reactor; you can specify nil instead. However, an object may have several reactors attached to it. Include an identifying text string, or other data your application can use, to allow you to distinguish among the different reactors attached to an object.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Advanced Topics","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4bec.htm"},{"title": "Attaching Reactors to AutoCAD Drawings","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c34.htm"},{"title": "Creating Reactors","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c2a.htm"}]},
{"title":"Working with Reactors in Multiple Namespaces",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c23.htm",
"description":"The current implementation of AutoLISP supports working in one drawing document at a time. Some AutoCAD APIs, such as ObjectARX and VBA, do support the ability of an application to work simultaneously in multiple documents. As a result, an application may modify an open drawing that is not currently active. This is not supported in AutoLISP. (Note that a VLX may run in a separate-namespace from the document it is loaded from, but it is still associated with that document and cannot manipulate objects in another document.)",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Advanced Topics","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4bec.htm"},{"title": "Attaching Reactors to AutoCAD Drawings","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c34.htm"}]},
{"title":"Querying, Modifying, and Removing Reactors",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c22.htm",
"description":"There are various ways to obtain information about reactors. VLISP supplies AutoLISP functions to query reactors, and you can use standard VLISP data inspection tools to view information on them.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Advanced Topics","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4bec.htm"},{"title": "Attaching Reactors to AutoCAD Drawings","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c34.htm"}]},
{"title":"Inspecting Reactors",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c21.htm",
"description":"You can examine reactors using the VLISP Inspect tool. For example, the object reactor defined in was returned to the variable circleReactor. If you open an Inspect window for this variable, VLISP displays the following information:",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Advanced Topics","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4bec.htm"},{"title": "Attaching Reactors to AutoCAD Drawings","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c34.htm"},{"title": "Querying, Modifying, and Removing Reactors","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c22.htm"}]},
{"title":"Querying Reactors Using Function Calls",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c1d.htm",
"description":"VLISP also provides functions to inspect a reactor definition from within an application program, or at the Console prompt:",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Advanced Topics","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4bec.htm"},{"title": "Attaching Reactors to AutoCAD Drawings","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c34.htm"},{"title": "Querying, Modifying, and Removing Reactors","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c22.htm"}]},
{"title":"Modifying Reactors",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c1b.htm",
"description":"VLISP provides functions to modify reactor definitions:",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Advanced Topics","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4bec.htm"},{"title": "Attaching Reactors to AutoCAD Drawings","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c34.htm"},{"title": "Querying, Modifying, and Removing Reactors","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c22.htm"}]},
{"title":"Removing Reactors",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c17.htm",
"description":"Use the vlr-remove function to disable a reactor. Disabling the reactor does not delete it: the Reactor object still exists and you can activate it again using the vlr-add function. To determine whether or not a reactor is active (registered to AutoCAD), use the vlr-added-p function:",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Advanced Topics","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4bec.htm"},{"title": "Attaching Reactors to AutoCAD Drawings","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c34.htm"},{"title": "Querying, Modifying, and Removing Reactors","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c22.htm"}]},
{"title":"Transient versus Persistent Reactors",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c16.htm",
"description":"Reactors may be transient or persistent. Transient reactors are lost when a drawing closes; this is the default reactor mode. Persistent reactors are saved with the drawing and exist when the drawing is next opened.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Advanced Topics","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4bec.htm"},{"title": "Attaching Reactors to AutoCAD Drawings","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c34.htm"}]},
{"title":"Opening a Drawing Containing Persistent Reactors",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c15.htm",
"description":"A reactor is only a link between an event and a callback function. While this link remains, the callback function itself is not part of the reactor, and is normally not part of the drawing. The reactors saved in the drawing are only usable if their associated callback functions are loaded in AutoCAD. You can cause this to occur automatically when a drawing is opened if you define the reactor and callback functions in a separate-namespace VLX.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Advanced Topics","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4bec.htm"},{"title": "Attaching Reactors to AutoCAD Drawings","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c34.htm"},{"title": "Transient versus Persistent Reactors","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c16.htm"}]},
{"title":"Reactor Use Guidelines",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c14.htm",
"description":"When using reactors, try to adhere to the following guidelines. Reactors that violate these guidelines can result in unpredictable results for your application if the internal implementation of reactors changes.",
"ancestors":[{"title": "Using the Visual LISP Environment","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4131.htm"},{"title": "Advanced Topics","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4bec.htm"},{"title": "Attaching Reactors to AutoCAD Drawings","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c34.htm"}]},
{"title":"Using the AutoLISP Language",
"href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm",
"description":"",
"ancestors":[]},
{"title":"AutoLISP Basics",
"href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-5b98.htm",
"description":"You can use number, string, and list-handling functions to customize AutoCAD.",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"}]},
{"title":"AutoLISP Expressions",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c74.htm",
"description":"An AutoLISP program consists of a series of expressions. AutoLISP expressions have the following form:",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "AutoLISP Basics","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-5b98.htm"}]},
{"title":"AutoLISP Function Syntax",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c73.htm",
"description":"In this guide, the following conventions describe the syntax for AutoLISP functions:",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "AutoLISP Basics","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-5b98.htm"},{"title": "AutoLISP Expressions","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c74.htm"}]},
{"title":"AutoLISP Data Types",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c70.htm",
"description":"AutoLISP expressions are processed according to the order and data type of the code within the parentheses. Before you can fully utilize AutoLISP, you must understand the differences among the data types and how to use them.",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "AutoLISP Basics","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-5b98.htm"}]},
{"title":"Integers",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c6f.htm",
"description":"Integers are whole numbers that do not contain a decimal point. AutoLISP integers are 32-bit signed numbers with values ranging from +2,147,483,647 to -2,147,483,648. (Note, however, that the getint function only accepts 16-bit numbers ranging from +32767 to -32678.) When you explicitly use an integer in an AutoLISP expression, that value is known as a constant. Numbers such as 2, -56, and 1,200,196 are valid AutoLISP integers.",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "AutoLISP Basics","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-5b98.htm"},{"title": "AutoLISP Data Types","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c70.htm"}]},
{"title":"Reals",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c6e.htm",
"description":"A real is a number containing a decimal point. Numbers between -1 and 1 must contain a leading zero. Real numbers are stored in double-precision floating-point format, providing at least 14 significant digits of precision. Note that VLISP does not show you all the significant digits.",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "AutoLISP Basics","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-5b98.htm"},{"title": "AutoLISP Data Types","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c70.htm"}]},
{"title":"Strings",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c6d.htm",
"description":"A string is a group of characters surrounded by quotation marks. Within quoted strings the backslash (\) character allows control characters (or escape codes) to be included. When you explicitly use a quoted string in an AutoLISP expression, that value is known as a literal string or a string constant.",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "AutoLISP Basics","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-5b98.htm"},{"title": "AutoLISP Data Types","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c70.htm"}]},
{"title":"Lists",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c6c.htm",
"description":"An AutoLISP list is a group of related values separated by spaces and enclosed in parentheses. Lists provide an efficient method of storing numerous related values. AutoCAD expresses 3D points as a list of three real numbers.",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "AutoLISP Basics","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-5b98.htm"},{"title": "AutoLISP Data Types","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c70.htm"}]},
{"title":"Selection Sets",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c6b.htm",
"description":"Selection sets are groups of one or more objects (entities). You can interactively add objects to, or remove objects from, selection sets with AutoLISP routines.",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "AutoLISP Basics","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-5b98.htm"},{"title": "AutoLISP Data Types","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c70.htm"}]},
{"title":"Entity Names",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c6a.htm",
"description":"An entity name is a numeric label assigned to objects in a drawing. It is actually a pointer into a file maintained by AutoCAD, and can be used to find the object\'s database record and its vectors (if they are displayed). This label can be referenced by AutoLISP functions to allow selection of objects for processing in various ways. Internally, AutoCAD refers to objects as entities.",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "AutoLISP Basics","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-5b98.htm"},{"title": "AutoLISP Data Types","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c70.htm"}]},
{"title":"VLA-objects",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c69.htm",
"description":"Objects in a drawing can be represented as Visual LISP ActiveX® (VLA) objects, a data type introduced with Visual LISP. When working with ActiveX functions, you must refer to VLA-objects, not the ename pointer returned by functions such as entlast. For information on working with ActiveX objects, see .",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "AutoLISP Basics","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-5b98.htm"},{"title": "AutoLISP Data Types","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c70.htm"}]},
{"title":"File Descriptors",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c68.htm",
"description":"A file descriptor is a pointer to a file opened by the AutoLISP open function. The open function returns this pointer as an alphanumeric label. You supply the file descriptor as an argument to other AutoLISP functions that read or write to the file.",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "AutoLISP Basics","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-5b98.htm"},{"title": "AutoLISP Data Types","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c70.htm"}]},
{"title":"Symbols and Variables",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c67.htm",
"description":"AutoLISP uses symbols to refer to data. Symbol names are not case sensitive and may consist of any sequence of alphanumeric and notation characters, except the following:",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "AutoLISP Basics","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-5b98.htm"},{"title": "AutoLISP Data Types","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c70.htm"}]},
{"title":"Protected Symbols",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c65.htm",
"description":"You may be warned if you attempt to change the value of some symbols used by the AutoLISP language. These symbols are known as protected symbols, and include items such as arithmetic operators (for example, +, -) and the values T and nil. You can use the Visual LISP Symbol Service feature to determine if a symbol is protected.",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "AutoLISP Basics","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-5b98.htm"},{"title": "AutoLISP Data Types","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c70.htm"},{"title": "Symbols and Variables","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c67.htm"}]},
{"title":"AutoLISP Program Files",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c62.htm",
"description":"Although you can enter AutoLISP code in the Visual LISP Console window or at the AutoCAD Command prompt, testing and debugging a series of instructions are considerably easier when you save AutoLISP code in a file rather than re-entering it each time you make a refinement. AutoLISP source code is usually stored in ASCII text files with an .lsp extension. However, you can load AutoLISP code from any ASCII text file.",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "AutoLISP Basics","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-5b98.htm"}]},
{"title":"Formatting AutoLISP Code",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c61.htm",
"description":"The extensive use of parentheses in AutoLISP code can make it difficult to read. The traditional technique for combatting this confusion is indentation. The more deeply nested a line of code is, the farther to the right you position the line.",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "AutoLISP Basics","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-5b98.htm"},{"title": "AutoLISP Program Files","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c62.htm"}]},
{"title":"Spaces in AutoLISP Code",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c60.htm",
"description":"In AutoLISP, multiple spaces between variable names, constants, and function names are equivalent to a single space. The end of a line is also treated as a single space.",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "AutoLISP Basics","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-5b98.htm"},{"title": "AutoLISP Program Files","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c62.htm"},{"title": "Formatting AutoLISP Code","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c61.htm"}]},
{"title":"Comments in AutoLISP Program Files",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c5f.htm",
"description":"It is good practice to include comments in AutoLISP program files. Comments are useful to both the programmer and future users who may need to revise a program to suit their needs. Use comments to do the following:",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "AutoLISP Basics","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-5b98.htm"},{"title": "AutoLISP Program Files","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c62.htm"}]},
{"title":"Visual LISP Comment Styles",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c5d.htm",
"description":"The VLISP code formatter recognizes five types of comments and positions each comment according to its type. Refer to for a description of each comment style.",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "AutoLISP Basics","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-5b98.htm"},{"title": "AutoLISP Program Files","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c62.htm"},{"title": "Comments in AutoLISP Program Files","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c5f.htm"}]},
{"title":"Color Coding",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c5c.htm",
"description":"VLISP provides an additional solution to make AutoLISP text easier to read: color coding. VLISP looks at each word of text and tries to determine what type of AutoLISP language element the word represents (for example, a built-in function, a number, or a string). Every type of element is assigned its own color, so you can easily distinguish among them when viewing the code. See for more information on the VLISP color coding feature.",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "AutoLISP Basics","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-5b98.htm"},{"title": "AutoLISP Program Files","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c62.htm"}]},
{"title":"AutoLISP Variables",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c5b.htm",
"description":"An AutoLISP variable assumes the data type of the value assigned to it. Until they are assigned new values, variables retain their original values. You use the AutoLISP setq function to assign values to variables.",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "AutoLISP Basics","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-5b98.htm"}]},
{"title":"Displaying the Value of a Variable",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c5a.htm",
"description":"To display the current value of a variable when working in Visual LISP, just enter the variable name at the Console prompt as follows:",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "AutoLISP Basics","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-5b98.htm"},{"title": "AutoLISP Variables","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c5b.htm"}]},
{"title":"Nil Variables",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c59.htm",
"description":"An AutoLISP variable that has not been assigned a value is said to be nil. This is different from blank, which is considered a character string, and different from 0, which is a number. So, in addition to checking a variable for its current value, you can test to determine if the variable has been assigned a value.",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "AutoLISP Basics","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-5b98.htm"},{"title": "AutoLISP Variables","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c5b.htm"}]},
{"title":"Predefined Variables",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c58.htm",
"description":"The following predefined variables are commonly used in AutoLISP applications:",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "AutoLISP Basics","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-5b98.htm"},{"title": "AutoLISP Variables","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c5b.htm"}]},
{"title":"Number Handling",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c57.htm",
"description":"AutoLISP provides functions for working with integers and real numbers. In addition to performing complex mathematical computations in applications, you can use the number-handling functions to help you in your daily use of AutoCAD. If you are drawing a steel connection detail that uses a 2.5\" bolt that is 0.5\" in diameter, how many threads are there if the bolt has 13 threads per inch? Use the * (multiplication) function at the Console prompt, as in the following example:",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "AutoLISP Basics","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-5b98.htm"}]},
{"title":"String Handling",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c56.htm",
"description":"AutoLISP provides functions for working with string values. For example, the strcase function returns the conversion of all alphabetic characters in a string to uppercase or lowercase. It accepts two arguments: a string and an optional argument that specifies the case in which the characters are returned. If the optional second argument is omitted, it evaluates to nil and strcase returns the characters converted to uppercase.",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "AutoLISP Basics","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-5b98.htm"}]},
{"title":"Basic Output Functions",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c55.htm",
"description":"AutoLISP includes functions for controlling the AutoCAD display, including both text and graphics windows. Some functions also display information in the Visual LISP Console window. The major text display functions are:",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "AutoLISP Basics","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-5b98.htm"}]},
{"title":"Displaying Messages",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c53.htm",
"description":"When entered from VLISP, the prompt function displays a message (a string) in the AutoCAD Command window and returns nil to the VLISP Console window. The princ, prin1, and print functions all display an expression (not necessarily a string) in the AutoCAD Command window and return the expression to the VLISP Console window. Optionally, these functions can send output to a file. The differences are as follows:",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "AutoLISP Basics","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-5b98.htm"},{"title": "Basic Output Functions","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c55.htm"}]},
{"title":"Exiting Quietly",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c51.htm",
"description":"If you invoke the princ function without passing an expression to it, it displays nothing and has no value to return. So if you write an AutoLISP expression that ends with a call to princ without any arguments, the ending nil is suppressed (because it has nothing to return). This practice is called exiting quietly.",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "AutoLISP Basics","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-5b98.htm"},{"title": "Basic Output Functions","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c55.htm"},{"title": "Displaying Messages","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c53.htm"}]},
{"title":"Control Characters in Strings",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c50.htm",
"description":"Within quoted strings, the backslash (\) character allows control characters (or escape codes) to be included. The following table shows the currently recognized control characters:",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "AutoLISP Basics","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-5b98.htm"},{"title": "Basic Output Functions","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c55.htm"}]},
{"title":"Wild-Card Matching",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c4d.htm",
"description":"The wcmatch function enables applications to compare a string to a wild-card pattern. You can use this facility when you build a selection set (in conjunction with ssget) and when you retrieve extended entity data by application name (in conjunction with entget).",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "AutoLISP Basics","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-5b98.htm"},{"title": "Basic Output Functions","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c55.htm"}]},
{"title":"Equality and Conditional",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c4c.htm",
"description":"AutoLISP includes functions that provide equality verification as well as conditional branching and looping. The equality and conditional functions are listed in under the heading These functions are described in the AutoLISP Reference.",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "AutoLISP Basics","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-5b98.htm"}]},
{"title":"List Handling",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c4b.htm",
"description":"AutoLISP provides functions for working with lists. This section provides examples of the append, assoc, car, cons, list, nth, and subst functions. A summary of all list-handling functions is in under the heading Each list-handling function is described in the AutoLISP Reference.",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "AutoLISP Basics","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-5b98.htm"}]},
{"title":"Point Lists",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c4a.htm",
"description":"AutoLISP observes the following conventions for handling graphics coordinates. Points are expressed as lists of two or three numbers surrounded by parentheses.",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "AutoLISP Basics","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-5b98.htm"},{"title": "List Handling","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c4b.htm"}]},
{"title":"Dotted Pairs",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c48.htm",
"description":"Another way AutoLISP uses lists to organize data is with a special type of list called a dotted pair. This list must always contain two members. When representing a dotted pair, AutoLISP separates the members of the list with a period (.). Most list-handling functions will not accept a dotted pair as an argument, so you should be sure you are passing the right kind of list to a function.",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "AutoLISP Basics","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-5b98.htm"},{"title": "List Handling","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c4b.htm"}]},
{"title":"Symbol and Function Handling",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c47.htm",
"description":"AutoLISP provides a number of functions for handling symbols and variables. The symbol-handling functions are listed in under the heading Each symbol-handling function is described in the AutoLISP Reference.",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "AutoLISP Basics","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-5b98.htm"}]},
{"title":"Using defun to Define a Function",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c46.htm",
"description":"With AutoLISP, you can define your own functions. Once defined, these functions can be used at the AutoCAD Command prompt, the Visual LISP Console prompt, or within other AutoLISP expressions, just as you use the standard functions. You can also create your own AutoCAD commands, because commands are just a special type of function.",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "AutoLISP Basics","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-5b98.htm"},{"title": "Symbol and Function Handling","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c47.htm"}]},
{"title":"Compatibility of defun with Previous Versions of AutoCAD",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c45.htm",
"description":"The internal implementation of defun changed in AutoCAD 2000. This change will be transparent to the great majority of AutoLISP users upgrading from earlier versions of AutoCAD. The change only affects AutoLISP code that manipulated defun definitions as a list structure, such as by appending one function to another, as in the following code:",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "AutoLISP Basics","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-5b98.htm"},{"title": "Symbol and Function Handling","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c47.htm"},{"title": "Using defun to Define a Function","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c46.htm"}]},
{"title":"C:XXX Functions",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c44.htm",
"description":"If an AutoLISP function is defined with a name of the form C:xxx, it can be issued at the AutoCAD Command prompt in the same manner as a built-in AutoCAD command. This is true regardless of whether you define and load the function in VLISP or at the AutoCAD Command prompt. You can use this feature to add new commands to AutoCAD or to redefine existing commands.",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "AutoLISP Basics","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-5b98.htm"},{"title": "Symbol and Function Handling","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c47.htm"}]},
{"title":"Adding Commands",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c42.htm",
"description":"Using the C:XXX feature, you can define a command that displays a simple message.",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "AutoLISP Basics","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-5b98.htm"},{"title": "Symbol and Function Handling","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c47.htm"},{"title": "C:XXX Functions","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c44.htm"}]},
{"title":"Redefining AutoCAD Commands",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c41.htm",
"description":"Using AutoLISP, external commands, and the alias feature, you can define your own AutoCAD commands. You can use the UNDEFINE command to redefine a built-in AutoCAD command with a user-defined command of the same name. To restore the built-in definition of a command, use the REDEFINE command. The UNDEFINE command is in effect for the current editing session only.",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "AutoLISP Basics","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-5b98.htm"},{"title": "Symbol and Function Handling","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c47.htm"},{"title": "C:XXX Functions","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c44.htm"}]},
{"title":"Local Variables in Functions",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c40.htm",
"description":"AutoLISP provides a method for defining a list of symbols (variables) that are available only to your function. These are known as local variables.",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "AutoLISP Basics","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-5b98.htm"},{"title": "Symbol and Function Handling","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c47.htm"}]},
{"title":"Local Variables versus Global Variables",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c3f.htm",
"description":"The use of local variables ensures that the variables in your functions are unaffected by the surrounding application and that your variables do not remain available after the calling function has completed its task.",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "AutoLISP Basics","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-5b98.htm"},{"title": "Symbol and Function Handling","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c47.htm"},{"title": "Local Variables in Functions","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c40.htm"}]},
{"title":"Example Using Local Variables",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c3e.htm",
"description":"The following example shows the use of local variables in a user-defined function (be certain there is at least one space between the slash and the local variables).",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "AutoLISP Basics","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-5b98.htm"},{"title": "Symbol and Function Handling","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c47.htm"},{"title": "Local Variables in Functions","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c40.htm"}]},
{"title":"Functions with Arguments",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c3d.htm",
"description":"With AutoLISP, you can define functions that accept arguments. Unlike many of the standard AutoLISP functions, user-defined functions cannot have optional arguments. When you call a user-defined function that accepts arguments, you must provide values for all the arguments.",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "AutoLISP Basics","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-5b98.htm"},{"title": "Symbol and Function Handling","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c47.htm"}]},
{"title":"Special Forms",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c3c.htm",
"description":"Certain AutoLISP functions are considered special forms because they evaluate arguments in a different manner than most AutoLISP function calls. A typical function evaluates all arguments passed to it before acting on those arguments. Special forms either do not evaluate all their arguments, or only evaluate some arguments under certain conditions.",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "AutoLISP Basics","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-5b98.htm"},{"title": "Symbol and Function Handling","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c47.htm"},{"title": "Functions with Arguments","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c3d.htm"}]},
{"title":"Error Handling in AutoLISP",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c3a.htm",
"description":"The AutoLISP language provides several functions for error handling. You can use these functions to do the following:",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "AutoLISP Basics","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-5b98.htm"}]},
{"title":"Using the *error* Function",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c38.htm",
"description":"Proper use of the *error* function can ensure that AutoCAD returns to a particular state after an error occurs. Through this user-definable function you can assess the error condition and return an appropriate message to the user. If AutoCAD encounters an error during evaluation, it prints a message in the following form:",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "AutoLISP Basics","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-5b98.htm"},{"title": "Error Handling in AutoLISP","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c3a.htm"}]},
{"title":"Catching Errors and Continuing Program Execution",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c37.htm",
"description":"Your program can intercept and attempt to process errors instead of allowing control to pass to *error*. The vl-catch-all-apply function is designed to invoke any function, return a value from the function, and trap any error that may occur. The function requires two arguments: a symbol identifying a function or lambda expression, and a list of arguments to be passed to the called function. The following example uses vl-catch-all-apply to divide two numbers:",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "AutoLISP Basics","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-5b98.htm"},{"title": "Error Handling in AutoLISP","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7c3a.htm"}]},
{"title":"Using AutoLISP to Communicate with AutoCAD",
"href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4b20.htm",
"description":"Query and command functions provide direct access to AutoCAD commands and drawing services.",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"}]},
{"title":"Accessing Commands and Services",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79fa.htm",
"description":"The query and command functions described in this section provide direct access to AutoCAD® commands and drawing services. Their behavior depends on the current state of the AutoCAD system and environment variables, and on the drawing that is currently loaded. See ##xref here - Query and Command Functions (app A Utility functions) in for a complete list of query and command functions.",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "Using AutoLISP to Communicate with AutoCAD","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4b20.htm"}]},
{"title":"Command Submission",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79f9.htm",
"description":"The command function sends an AutoCAD command directly to the AutoCAD Command prompt. The command function has a variable-length argument list. These arguments must correspond to the types and values expected by that command\'s prompt sequence; these may be strings, real values, integers, points, entity names, or selection set names. Data such as angles, distances, and points can be passed either as strings or as the values themselves (as integer or real values, or as point lists). An empty string (\"\") is equivalent to pressing the SPACEBAR or ENTER on the keyboard.",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "Using AutoLISP to Communicate with AutoCAD","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4b20.htm"},{"title": "Accessing Commands and Services","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79fa.htm"}]},
{"title":"Foreign Language Support",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79f7.htm",
"description":"If you develop AutoLISP programs that can be used with a foreign language version of AutoCAD, the standard AutoCAD commands and keywords are automatically translated if you precede each command or keyword with an underscore (_).",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "Using AutoLISP to Communicate with AutoCAD","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4b20.htm"},{"title": "Accessing Commands and Services","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79fa.htm"},{"title": "Command Submission","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79f9.htm"}]},
{"title":"Pausing for User Input",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79f6.htm",
"description":"If an AutoCAD command is in progress and the predefined symbol PAUSE is encountered as an argument to command, the command is suspended to allow direct user input (usually point selection or dragging). This is similar to the backslash pause mechanism provided for menus.",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "Using AutoLISP to Communicate with AutoCAD","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4b20.htm"},{"title": "Accessing Commands and Services","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79fa.htm"},{"title": "Command Submission","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79f9.htm"}]},
{"title":"Passing Pick Points to AutoCAD Commands",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79f5.htm",
"description":"Some AutoCAD commands (such as TRIM, EXTEND, and FILLET) require the user to specify a pick point as well as the object itself. To pass such pairs of object and point data by means of the command function without the use of a PAUSE, you must first store them as variables. Points can be passed as strings within the command function or can be defined outside the function and passed as variables, as shown in the following example. This code fragment shows one method of passing an entity name and a pick point to the command function.",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "Using AutoLISP to Communicate with AutoCAD","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4b20.htm"},{"title": "Accessing Commands and Services","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79fa.htm"},{"title": "Command Submission","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79f9.htm"}]},
{"title":"Undoing Commands Issued with the command Function",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79f3.htm",
"description":"An UNDO group is explicitly created around each command used with the command function. If a user enters U (or UNDO) after running an AutoLISP routine, only the last command will be undone. Additional entries of UNDO will step backward through the commands used in that routine. If you want a group of commands to be considered a group (or the entire routine), use the UNDO Begin and UNDO End options.",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "Using AutoLISP to Communicate with AutoCAD","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4b20.htm"},{"title": "Accessing Commands and Services","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79fa.htm"},{"title": "Command Submission","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79f9.htm"}]},
{"title":"System and Environment Variables",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79f2.htm",
"description":"With the getvar and setvar functions, AutoLISP applications can inspect and change the value of AutoCAD system variables. These functions use a string to specify the variable name. The setvar function specifies a value of the type that the system variable expects. AutoCAD system variables come in various types: integers, real values, strings, 2D points, and 3D points. Values supplied as arguments to setvar must be of the expected type. If an invalid type is supplied, an AutoLISP error is generated.",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "Using AutoLISP to Communicate with AutoCAD","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4b20.htm"},{"title": "Accessing Commands and Services","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79fa.htm"}]},
{"title":"Configuration Control",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79f1.htm",
"description":"AutoCAD uses the acadxx.cfg file to store configuration information (the xx in the file name refers to the AutoCAD release number). The AppData section of this file is provided for users and developers to store configuration information pertaining to their applications. The getcfg and setcfg functions allow AutoLISP applications to inspect and change the value of parameters in the AppData section.",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "Using AutoLISP to Communicate with AutoCAD","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4b20.htm"},{"title": "Accessing Commands and Services","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79fa.htm"}]},
{"title":"Display Control",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79f0.htm",
"description":"AutoLISP includes functions for controlling the AutoCAD display in both text and graphics windows. Some functions prompt for, or depend on, input from the AutoCAD user.",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "Using AutoLISP to Communicate with AutoCAD","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4b20.htm"}]},
{"title":"Controlling Menus",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79ef.htm",
"description":"The menucmd function controls the display of the graphics window menus. It displays, modifies, or queries one of the submenus of the current menu, and accepts a string argument that specifies the submenu and the action to perform on that submenu.",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "Using AutoLISP to Communicate with AutoCAD","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4b20.htm"},{"title": "Display Control","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79f0.htm"}]},
{"title":"Control of Graphics and Text Windows",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79ee.htm",
"description":"You can control the display of the graphics and text windows from an AutoLISP application. On single-screen AutoCAD installations, a call to graphscr displays the graphics window, and a call to textscr displays the text window. Using these functions is equivalent to toggling the Flip Screen function key. The function textpage is equivalent to textscr.",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "Using AutoLISP to Communicate with AutoCAD","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4b20.htm"},{"title": "Display Control","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79f0.htm"}]},
{"title":"Control of Low-Level Graphics",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79ed.htm",
"description":"AutoLISP provides functions that control the low-level graphics and allow direct access to the AutoCAD graphics screen and input devices.",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "Using AutoLISP to Communicate with AutoCAD","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4b20.htm"},{"title": "Display Control","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79f0.htm"}]},
{"title":"Getting User Input",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79ec.htm",
"description":"Several functions enable an AutoLISP application to prompt the user for input of data. See in for a complete list of user input functions.",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "Using AutoLISP to Communicate with AutoCAD","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4b20.htm"}]},
{"title":"The getxxx Functions",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79eb.htm",
"description":"Each user-input getxxx function pauses for data entry of the indicated type and returns the value entered. The application specifies an optional prompt to display before the function pauses. The following table lists the getxxx functions and the type of user input requested.",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "Using AutoLISP to Communicate with AutoCAD","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4b20.htm"},{"title": "Getting User Input","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79ec.htm"}]},
{"title":"Control of User-Input Function Conditions",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79e7.htm",
"description":"The initget function provides a level of control over the next user-input function call. The initget function establishes various options for use by the next entsel, nentsel, nentselp, or getxxx function (except getstring, getvar, and getenv). This function accepts two arguments, bits and string, both of which are optional. The bits argument specifies one or more control bits that enable or disable certain input values to the next user-input function call. The string argument can specify keywords that the next user-input function call will recognize.",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "Using AutoLISP to Communicate with AutoCAD","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4b20.htm"},{"title": "Getting User Input","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79ec.htm"}]},
{"title":"Input Options for User-Input Functions",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79e6.htm",
"description":"The value of the bits argument restricts the types of user input to the next user-input function call. This reduces error-checking. These are some of the available bit values: 1 disallows null input, 2 disallows input of 0 (zero), and 4 disallows negative input. If these values are used with a following call to the getint function, the user is forced to enter an integer value greater than 0.",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "Using AutoLISP to Communicate with AutoCAD","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4b20.htm"},{"title": "Getting User Input","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79ec.htm"},{"title": "Control of User-Input Function Conditions","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79e7.htm"}]},
{"title":"Keyword Options",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79e5.htm",
"description":"The optional string argument specifies a list of keywords recognized by the next user-input function call.",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "Using AutoLISP to Communicate with AutoCAD","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4b20.htm"},{"title": "Getting User Input","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79ec.htm"},{"title": "Control of User-Input Function Conditions","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79e7.htm"}]},
{"title":"Arbitrary Keyboard Input",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79e4.htm",
"description":"The initget function also allows arbitrary keyboard input to most getxxx functions. This input is passed back to the application as a string. An application using this facility can be written to permit the user to call an AutoLISP function at a getxxx function prompt.",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "Using AutoLISP to Communicate with AutoCAD","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4b20.htm"},{"title": "Getting User Input","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79ec.htm"},{"title": "Control of User-Input Function Conditions","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79e7.htm"}]},
{"title":"Input Validation",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79e3.htm",
"description":"You should protect your code from unintentional user errors. The AutoLISP user input getxxx functions do much of this for you. However, it\'s dangerous to forget to check for adherence to other program requirements that the getxxx functions do not check for. If you neglect to check input validity, the program\'s integrity can be seriously affected.",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "Using AutoLISP to Communicate with AutoCAD","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4b20.htm"},{"title": "Getting User Input","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79ec.htm"},{"title": "Control of User-Input Function Conditions","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79e7.htm"}]},
{"title":"Geometric Utilities",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79e2.htm",
"description":"A group of functions allows applications to obtain pure geometric information and geometric data from the drawing. See in for a complete list of geometric utility functions.",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "Using AutoLISP to Communicate with AutoCAD","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4b20.htm"}]},
{"title":"Object Snap",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79e1.htm",
"description":"The osnap function can find a point by using one of the AutoCAD Object Snap modes. The Snap modes are specified in a string argument.",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "Using AutoLISP to Communicate with AutoCAD","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4b20.htm"},{"title": "Geometric Utilities","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79e2.htm"}]},
{"title":"Text Extents",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79e0.htm",
"description":"The textbox function returns the diagonal coordinates of a box that encloses a text object. It takes an entity definition list of the type returned by entget (an association list of group codes and values) as its single argument. This list can contain a complete association list description of the text object or just a list describing the text string.",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "Using AutoLISP to Communicate with AutoCAD","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4b20.htm"},{"title": "Geometric Utilities","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79e2.htm"}]},
{"title":"Conversions",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79dc.htm",
"description":"The functions described in this section are utilities for converting data types and units. See in for a complete list of conversion functions.",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "Using AutoLISP to Communicate with AutoCAD","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4b20.htm"}]},
{"title":"String Conversions",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79db.htm",
"description":"The functions rtos (real to string) and angtos (angle to string) convert numeric values used in AutoCAD to string values that can be used in output or as textual data. The rtos function converts a real value, and angtos converts an angle. The format of the result string is controlled by the value of AutoCAD system variables: the units and precision are specified by LUNITS and LUPREC for real (linear) values and by AUNITS and AUPREC for angular values. For both functions, the dimensioning variable DIMZIN controls how leading and trailing zeros are written to the result string.",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "Using AutoLISP to Communicate with AutoCAD","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4b20.htm"},{"title": "Conversions","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79dc.htm"}]},
{"title":"Angular Conversion",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79d9.htm",
"description":"If your application needs to convert angular values from radians to degrees, you can use the angtos function, which returns a string, and then convert that string into a floating point value with atof.",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "Using AutoLISP to Communicate with AutoCAD","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4b20.htm"},{"title": "Conversions","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79dc.htm"}]},
{"title":"ASCII Code Conversion",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79d8.htm",
"description":"AutoLISP provides the ascii and chr functions that handle decimal ASCII codes. The ascii function returns the ASCII decimal value associated with a string, and chr returns the character associated with an ASCII decimal value.",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "Using AutoLISP to Communicate with AutoCAD","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4b20.htm"},{"title": "Conversions","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79dc.htm"}]},
{"title":"Unit Conversion",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79d7.htm",
"description":"The acad.unt file defines various conversions between real-world units such as miles to kilometers, Fahrenheit to Celsius, and so on. The function cvunit takes a value expressed in one system of units and returns the equivalent value in another system. The two systems of units are specified by strings containing expressions of units defined in acad.unt.",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "Using AutoLISP to Communicate with AutoCAD","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4b20.htm"},{"title": "Conversions","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79dc.htm"}]},
{"title":"Converting from Inches to Meters",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79d6.htm",
"description":"If the current drawing units are engineering or architectural (feet and inches), the following routine converts a user-specified distance of inches into meters:",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "Using AutoLISP to Communicate with AutoCAD","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4b20.htm"},{"title": "Conversions","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79dc.htm"},{"title": "Unit Conversion","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79d7.htm"}]},
{"title":"The Unit Definition File",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79d5.htm",
"description":"With the AutoCAD unit definition file acad.unt, you can define factors to convert data in one set of units to another set of units. The definitions in acad.unt are in ASCII format and are used by the unit-conversion function cvunit.",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "Using AutoLISP to Communicate with AutoCAD","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4b20.htm"},{"title": "Conversions","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79dc.htm"},{"title": "Unit Conversion","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79d7.htm"}]},
{"title":"Coordinate System Transformations",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79d0.htm",
"description":"The trans function translates a point or a displacement from one coordinate system into another. It takes a point argument, pt, that can be interpreted as either a 3D point or a 3D displacement vector, distinguished by a displacement argument called disp. The disp argument must be nonzero if pt is to be treated as a displacement vector; otherwise, pt is treated as a point. A from argument specifies the coordinate system in which pt is expressed, and a to argument specifies the desired coordinate system. The following is the syntax for the trans function:",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "Using AutoLISP to Communicate with AutoCAD","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4b20.htm"},{"title": "Conversions","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79dc.htm"}]},
{"title":"Point Transformations",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79cd.htm",
"description":"If you are doing point transformations with the trans function and you need to make that part of a program run faster, you can construct your own transformation matrix on the AutoLISP side by using trans once to transform each of the basis vectors (0 0 0), (1 0 0), (0 1 0), and (0 0 1). Writing matrix multiplication functions in AutoLISP can be difficult, so it may not be worthwhile unless your program is doing a lot of transformations.",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "Using AutoLISP to Communicate with AutoCAD","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4b20.htm"},{"title": "Conversions","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79dc.htm"},{"title": "Coordinate System Transformations","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79d0.htm"}]},
{"title":"File Handling",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79cc.htm",
"description":"AutoLISP provides functions for handling files and data I/O. See in for a complete list of file-handling functions.",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "Using AutoLISP to Communicate with AutoCAD","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4b20.htm"}]},
{"title":"File Search",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79cb.htm",
"description":"An application can use the findfile function to search for a particular file name. The application can specify the directory to search, or it can use the current AutoCAD library path.",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "Using AutoLISP to Communicate with AutoCAD","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4b20.htm"},{"title": "File Handling","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79cc.htm"}]},
{"title":"Accessing Drawing Properties",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79ca.htm",
"description":"To access drawing properties such as Title, Subject, Author, and Keywords, use the IAcadSummaryInfo interface. This interface is accessible as a property of the Document object in the AutoCAD object model.",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "Using AutoLISP to Communicate with AutoCAD","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4b20.htm"},{"title": "File Handling","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79cc.htm"}]},
{"title":"Accessing Help Files",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79c9.htm",
"description":"The help function provides access to both Microsoft Compiled HTML Help files (.chm) and Windows Help files (.hlp). Depending on the Help file\'s extension, the help function calls the AutoCAD or the Windows Help viewer with the specified file. You can use this function to add a Help facility to your applications. The following code fragment calls the default AutoCAD Help file and provides information about the LINE command.",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "Using AutoLISP to Communicate with AutoCAD","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4b20.htm"},{"title": "File Handling","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79cc.htm"}]},
{"title":"Device Access and Control",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79c8.htm",
"description":"AutoLISP provides the grread and tablet functions for accessing data from the various input devices.",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "Using AutoLISP to Communicate with AutoCAD","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4b20.htm"}]},
{"title":"Accessing User Input",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79c7.htm",
"description":"The grread function returns raw user input, whether from the keyboard or from the pointing device (mouse or digitizer). If the call to grread enables tracking, the function returns a digitized coordinate that can be used for things such as dragging.",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "Using AutoLISP to Communicate with AutoCAD","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4b20.htm"},{"title": "Device Access and Control","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79c8.htm"}]},
{"title":"Calibrating Tablets",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79c6.htm",
"description":"AutoCAD users can calibrate a digitizing tablet by using the TABLET command (see the Command Reference for a description of this command). The tablet function enables applications to manage calibration by setting the calibrations directly and by saving those settings for future use.",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "Using AutoLISP to Communicate with AutoCAD","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4b20.htm"},{"title": "Device Access and Control","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79c8.htm"}]},
{"title":"Using AutoLISP to Manipulate AutoCAD Objects",
"href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-48c2.htm",
"description":"You can select and handle objects, and use their extended data.",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"}]},
{"title":"Selection Set Handling",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a34.htm",
"description":"AutoLISP provides a number of functions for handling selection sets. For a complete list of selection set functions, see in",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "Using AutoLISP to Manipulate AutoCAD Objects","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-48c2.htm"}]},
{"title":"Selection Set Filter Lists",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a31.htm",
"description":"An entity filter list is an association list that uses DXF group codes in the same format as a list returned by entget. (See the DXF Reference for a list of group codes.) The ssget function recognizes all group codes except entity names (group -1), handles (group 5), and xdata codes (groups greater than 1000). If an invalid group code is used in a filter-list, it is ignored by ssget. To search for objects with xdata, use the -3 code as described in .",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "Using AutoLISP to Manipulate AutoCAD Objects","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-48c2.htm"},{"title": "Selection Set Handling","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a34.htm"}]},
{"title":"Wild-Card Patterns in Filter Lists",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a2f.htm",
"description":"Symbol names specified in filtering lists can include wild-card patterns. The wild-card patterns recognized by ssget are the same as those recognized by the wcmatch function, and are described in , and under in the AutoLISP Reference.",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "Using AutoLISP to Manipulate AutoCAD Objects","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-48c2.htm"},{"title": "Selection Set Handling","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a34.htm"},{"title": "Selection Set Filter Lists","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a31.htm"}]},
{"title":"Filtering for Extended Data",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a2e.htm",
"description":"Using the ssgetfilter-list, you can select all entities containing extended data for a particular application. (See .) To do this, use the -3 group code, as shown in the following example:",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "Using AutoLISP to Manipulate AutoCAD Objects","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-48c2.htm"},{"title": "Selection Set Handling","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a34.htm"},{"title": "Selection Set Filter Lists","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a31.htm"}]},
{"title":"Relational Tests",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a2d.htm",
"description":"Unless otherwise specified, an equivalency is implied for each item in the filter-list. For numeric groups (integers, reals, points, and vectors), you can specify other relations by including a special -4 group code that specifies a relational operator. The value of a -4 group is a string indicating the test operator to be applied to the next group in the filter-list.",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "Using AutoLISP to Manipulate AutoCAD Objects","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-48c2.htm"},{"title": "Selection Set Handling","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a34.htm"},{"title": "Selection Set Filter Lists","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a31.htm"}]},
{"title":"Logical Grouping of Filter Tests",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a2a.htm",
"description":"You can also test groups by creating nested Boolean expressions that use the logical grouping operators shown in the following table:",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "Using AutoLISP to Manipulate AutoCAD Objects","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-48c2.htm"},{"title": "Selection Set Handling","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a34.htm"},{"title": "Selection Set Filter Lists","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a31.htm"}]},
{"title":"Selection Set Manipulation",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a28.htm",
"description":"Once a selection set has been created, you can add entities to it or remove entities from it with the functions ssadd and ssdel. You can use the ssadd function to create a new selection set, as shown in the following example. The following code fragment creates a selection set that includes the first and last entities in the current drawing (entnext and entlast are described later in this chapter).",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "Using AutoLISP to Manipulate AutoCAD Objects","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-48c2.htm"},{"title": "Selection Set Handling","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a34.htm"},{"title": "Selection Set Filter Lists","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a31.htm"}]},
{"title":"Passing Selection Sets between AutoLISP and ObjectARX Applications",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a27.htm",
"description":"When passing selection sets between AutoLISP and ObjectARX applications, the following should be observed:",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "Using AutoLISP to Manipulate AutoCAD Objects","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-48c2.htm"},{"title": "Selection Set Handling","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a34.htm"}]},
{"title":"Object Handling",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a26.htm",
"description":"AutoLISP provides functions for handling objects. The object-handling functions are organized into two categories: functions that retrieve the entity name of a particular object, and functions that retrieve or modify entity data. See in for a complete list of the object-handling functions.",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "Using AutoLISP to Manipulate AutoCAD Objects","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-48c2.htm"}]},
{"title":"Entity Name Functions",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a25.htm",
"description":"To operate on an object, an AutoLISP application must obtain its entity name for use in subsequent calls to the entity data or selection set functions. Two functions described in this section, entsel and nentsel, return not only the entity\'s name but additional information for the application\'s use.",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "Using AutoLISP to Manipulate AutoCAD Objects","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-48c2.htm"},{"title": "Object Handling","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a26.htm"}]},
{"title":"Entity Handles and Their Uses",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a24.htm",
"description":"The handent function retrieves the name of an entity with a specific handle. As with entity names, handles are unique within a drawing. However, an entity\'s handle is constant throughout its life. AutoLISP applications that manipulate a specific database can use handent to obtain the current name of an entity they must use. You can use the DDMODIFY command to get the handle of a selected object.",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "Using AutoLISP to Manipulate AutoCAD Objects","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-48c2.htm"},{"title": "Object Handling","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a26.htm"},{"title": "Entity Name Functions","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a25.htm"}]},
{"title":"Entity Context and Coordinate Transform Data",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a23.htm",
"description":"The nentsel and nentselp functions are similar to entsel, except they return two additional values to handle entities nested within block references.",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "Using AutoLISP to Manipulate AutoCAD Objects","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-48c2.htm"},{"title": "Object Handling","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a26.htm"},{"title": "Entity Name Functions","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a25.htm"}]},
{"title":"Entity Access Functions",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a1f.htm",
"description":"The entity access functions are relatively slow. It is best to get the contents of a particular entity (or symbol table entry) once and keep that information stored in memory, rather than repeatedly ask AutoCAD for the same data. Be sure the data remains valid. If the user has an opportunity to alter the entity or symbol table entry, you should reissue the entity access function to ensure the validity of the data.",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "Using AutoLISP to Manipulate AutoCAD Objects","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-48c2.htm"},{"title": "Object Handling","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a26.htm"},{"title": "Entity Name Functions","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a25.htm"}]},
{"title":"Entity Data Functions",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a1e.htm",
"description":"The functions described in this section operate on entity data and can be used to modify the current drawing database.",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "Using AutoLISP to Manipulate AutoCAD Objects","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-48c2.htm"},{"title": "Object Handling","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a26.htm"}]},
{"title":"Deleting an Entity",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a1d.htm",
"description":"The entdel function deletes a specified entity. The entity is not purged from the database until the end of the current drawing session, so if the application calls entdel a second time during that session and specifies the same entity, the entity is undeleted.",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "Using AutoLISP to Manipulate AutoCAD Objects","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-48c2.htm"},{"title": "Object Handling","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a26.htm"},{"title": "Entity Data Functions","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a1e.htm"}]},
{"title":"Obtaining Entity Information",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a1c.htm",
"description":"The entget function returns the definition data of a specified entity. The data is returned as a list. Each item in the list is specified by a DXF group code. The first item in the list contains the entity\'s current name.",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "Using AutoLISP to Manipulate AutoCAD Objects","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-48c2.htm"},{"title": "Object Handling","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a26.htm"},{"title": "Entity Data Functions","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a1e.htm"}]},
{"title":"Modifying an Entity",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a1a.htm",
"description":"The entmod function modifies an entity. It passes a list that has the same format as a list returned by entget but with some of the entity group values (presumably) modified by the application. This function complements entget. The primary mechanism by which an AutoLISP application updates the database is by retrieving an entity with entget, modifying its entity list, and then passing the list back to the database with entmod.",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "Using AutoLISP to Manipulate AutoCAD Objects","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-48c2.htm"},{"title": "Object Handling","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a26.htm"},{"title": "Entity Data Functions","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a1e.htm"}]},
{"title":"Adding an Entity to a Drawing",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a18.htm",
"description":"An application can add an entity to the drawing database by calling the entmake function. Like that of entmod, the argument to entmake is a list whose format is similar to that returned by entget. The new entity that the list describes is appended to the drawing database (it becomes the last entity in the drawing). If the entity is a complex entity (an old-style polyline or a block), it is not appended to the database until it is complete.",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "Using AutoLISP to Manipulate AutoCAD Objects","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-48c2.htm"},{"title": "Object Handling","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a26.htm"},{"title": "Entity Data Functions","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a1e.htm"}]},
{"title":"Creating Complex Entities",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a15.htm",
"description":"To create a complex entity (an old-style polyline or a block), you make multiple calls to entmake, using a separate call for each subentity. When entmake first receives an initial component for a complex entity, it creates a temporary file in which to gather the definition data and extended data, if present. (See .) For each subsequent entmake call, the function checks if the temporary file exists. If it does, the new subentity is appended to the file. When the definition of the complex entity is complete (that is, when entmake receives an appropriate seqend or endblk subentity), the entity is checked for consistency; if valid, it is added to the drawing. The file is deleted when the complex entity is complete or when its creation has been canceled.",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "Using AutoLISP to Manipulate AutoCAD Objects","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-48c2.htm"},{"title": "Object Handling","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a26.htm"},{"title": "Entity Data Functions","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a1e.htm"}]},
{"title":"Working with Blocks",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a14.htm",
"description":"There is no direct method for an application to check whether a block listed in the BLOCK table is actually referenced by an insert object in the drawing. You can use the following code to scan the drawing for instances of a block reference:",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "Using AutoLISP to Manipulate AutoCAD Objects","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-48c2.htm"},{"title": "Object Handling","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a26.htm"},{"title": "Entity Data Functions","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a1e.htm"}]},
{"title":"Anonymous Blocks",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a13.htm",
"description":"The block definitions (BLOCK) table in a drawing can contain anonymous blocks (also known as unnamed blocks), that AutoCAD creates to support hatch patterns and associative dimensioning. The entmake function can create anonymous blocks other than *Dnnn (dimensions) and *Xnnn (hatch patterns). Unreferenced anonymous blocks are purged from the BLOCK definition table when a drawing is opened. Referenced anonymous blocks (those that have been inserted) are not purged. You can use entmake to create a block reference (insert object) to an anonymous block. (You cannot pass an anonymous block to the INSERT command.) Also, you can use entmake to redefine the block. You can modify the entities in a block (but not the block object itself) with entmod.",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "Using AutoLISP to Manipulate AutoCAD Objects","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-48c2.htm"},{"title": "Object Handling","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a26.htm"},{"title": "Entity Data Functions","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a1e.htm"}]},
{"title":"Entity Data Functions and the Graphics Screen",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a12.htm",
"description":"Changes to the drawing made by the entity data functions are reflected on the graphics screen, provided the entity being deleted, undeleted, modified, or made is in an area and on a layer that is currently visible. There is one exception: When entmod modifies a subentity, it does not update the image of the entire (complex) entity. If, for example, an application modifies 100 vertices of an old-style polyline with 100 calls to entmod, the time required to recalculate and redisplay the entire polyline is unacceptably slow. Instead, an application can perform a series of subentity modifications, and then redisplay the entire entity with a single call to the entupd function.",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "Using AutoLISP to Manipulate AutoCAD Objects","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-48c2.htm"},{"title": "Object Handling","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a26.htm"}]},
{"title":"Old-Style Polylines and Lightweight Polylines",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a11.htm",
"description":"A lightweight polyline (lwpolyline) is defined in the drawing database as a single graphic entity. The lwpolyline differs from the old-style polyline, which is defined as a group of subentities. Lwpolylines display faster and consume less disk space and RAM.",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "Using AutoLISP to Manipulate AutoCAD Objects","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-48c2.htm"},{"title": "Object Handling","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a26.htm"}]},
{"title":"Processing Curve-Fit and Spline-Fit Polylines",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a10.htm",
"description":"When an AutoLISP application uses entnext to step through the vertices of an old-style polyline, it might encounter vertices that were not created explicitly. Auxiliary vertices are inserted automatically by the PEDIT command\'s Fit and Spline options. You can safely ignore them, because changes to these vertices will be discarded the next time the user applies PEDIT to fit or to spline the polyline.",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "Using AutoLISP to Manipulate AutoCAD Objects","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-48c2.htm"},{"title": "Object Handling","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a26.htm"},{"title": "Old-Style Polylines and Lightweight Polylines","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a11.htm"}]},
{"title":"Non-Graphic Object Handling",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a0f.htm",
"description":"AutoCAD uses two types of non-graphical objects: dictionary objects and symbol table objects. Although there are similarities between these object types, they are handled differently.",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "Using AutoLISP to Manipulate AutoCAD Objects","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-48c2.htm"},{"title": "Object Handling","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a26.htm"}]},
{"title":"Symbol Table Objects",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a0e.htm",
"description":"The following rules apply to symbol tables:",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "Using AutoLISP to Manipulate AutoCAD Objects","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-48c2.htm"},{"title": "Object Handling","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a26.htm"},{"title": "Non-Graphic Object Handling","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a0f.htm"}]},
{"title":"Dictionary Objects",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a0a.htm",
"description":"The following rules apply to dictionary objects:",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "Using AutoLISP to Manipulate AutoCAD Objects","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-48c2.htm"},{"title": "Object Handling","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a26.htm"},{"title": "Non-Graphic Object Handling","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a0f.htm"}]},
{"title":"Extended Data - xdata",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a08.htm",
"description":"Several AutoLISP functions are provided to handle extended data (xdata), which is created by applications written with ObjectARX or AutoLISP. If an entity contains xdata, it follows the entity\'s regular definition data.",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "Using AutoLISP to Manipulate AutoCAD Objects","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-48c2.htm"}]},
{"title":"Organization of Extended Data",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a06.htm",
"description":"Extended data consists of one or more 1001 groups, each of which begins with a unique application name. The xdata groups returned by entget follow the definition data in the order in which they are saved in the database.",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "Using AutoLISP to Manipulate AutoCAD Objects","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-48c2.htm"},{"title": "Extended Data - xdata","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a08.htm"}]},
{"title":"Registration of an Application",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a05.htm",
"description":"To be recognized by AutoCAD, an application must register the name or names that it uses. Application names are saved with the extended data of each entity that uses them, and also in the APPID table. Registration is done with the regapp function, which specifies a string to use as an application name. If it successfully adds the name to APPID, it returns the name of the application; otherwise it returns nil. A result of nil indicates that the name is already present in the symbol table. This is not an actual error condition but an expected return value, because the application name needs to be registered only once per drawing.",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "Using AutoLISP to Manipulate AutoCAD Objects","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-48c2.htm"},{"title": "Extended Data - xdata","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a08.htm"}]},
{"title":"Retrieval of Extended Data",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a04.htm",
"description":"An application can call entget to obtain the xdata that it has registered. The entget function can return both the definition data and the xdata for the applications it requests. It requires an additional argument, application, that specifies the application names. The names passed to entget must correspond to applications registered by a previous call to regapp; they can also contain wild-card characters.",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "Using AutoLISP to Manipulate AutoCAD Objects","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-48c2.htm"},{"title": "Extended Data - xdata","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a08.htm"}]},
{"title":"Attachment of Extended Data to an Entity",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a03.htm",
"description":"You can use xdata to store any type of information you want. For example, draw an entity (such as a line or a circle), then enter the following code to attach xdata to the entity:",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "Using AutoLISP to Manipulate AutoCAD Objects","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-48c2.htm"},{"title": "Extended Data - xdata","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a08.htm"}]},
{"title":"Management of Extended Data Memory Use",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a02.htm",
"description":"Extended data is currently limited to 16K per entity. Because the xdata of an entity can be created and maintained by multiple applications, problems can result when the size of the xdata approaches its limit. AutoLISP provides two functions, xdsize and xdroom, to assist in managing the memory that xdata occupies. When xdsize is passed a list of xdata, it returns the amount of memory (in bytes) that the data will occupy. When xdroom is passed the name of an entity, it returns the remaining number of free bytes that can still be appended to the entity.",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "Using AutoLISP to Manipulate AutoCAD Objects","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-48c2.htm"},{"title": "Extended Data - xdata","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a08.htm"}]},
{"title":"Handles in Extended Data",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a01.htm",
"description":"Extended data can contain handles (group 1005) to save relational structures within a drawing. One entity can reference another by saving the other\'s handle in its xdata. The handle can be retrieved later from xdata and then passed to handent to obtain the other entity. Because more than one entity can reference another, xdata handles are not necessarily unique. The AUDIT command does require that handles in extended data either be NULL or valid entity handles (within the current drawing). The best way to ensure that xdata entity handles are valid is to obtain a referenced entity\'s handle directly from its definition data by means of entget. The handle value is in group 5.",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "Using AutoLISP to Manipulate AutoCAD Objects","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-48c2.htm"},{"title": "Extended Data - xdata","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a08.htm"}]},
{"title":"Xrecord Objects",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a00.htm",
"description":"Xrecord objects are used to store and manage arbitrary data. They are composed of DXF group codes with normal object groups (that is, non-xdata group codes), ranging from 1 through 369 for supported ranges. These objects are similar in concept to xdata but is not limited by size or order.",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "Using AutoLISP to Manipulate AutoCAD Objects","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-48c2.htm"}]},
{"title":"Symbol Table and Dictionary Access",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79ff.htm",
"description":"AutoLISP provides functions for accessing symbol table and dictionary entries. Examples of the tblnext and tblsearch functions are provided in the following sections. For a complete list of the symbol table and dictionary access functions, see in Refer to the AutoLISP Reference for more detailed information on the functions listed in the Synopsis.",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "Using AutoLISP to Manipulate AutoCAD Objects","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-48c2.htm"}]},
{"title":"Symbol Tables",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79fe.htm",
"description":"Symbol table entries can also be manipulated by the following functions:",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "Using AutoLISP to Manipulate AutoCAD Objects","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-48c2.htm"},{"title": "Symbol Table and Dictionary Access","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79ff.htm"}]},
{"title":"Dictionary Entries",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79fc.htm",
"description":"A dictionary is a container object, similar to the symbol tables in functions. Dictionary entries can be queried with the dictsearch and dictnext functions. Each dictionary entry consists of a text name key plus a hard ownership handle reference to the entry object. Dictionary entries may be removed by directly passing entry object names to the entdel function. The text name key uses the same syntax and valid characters as symbol table names.",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "Using AutoLISP to Manipulate AutoCAD Objects","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-48c2.htm"},{"title": "Symbol Table and Dictionary Access","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79ff.htm"}]},
{"title":"Accessing AutoCAD Groups",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79fb.htm",
"description":"The following is an example of one method for accessing the entities contained in a group. This example assumes a group named G1 exists in the current drawing.",
"ancestors":[{"title": "Using the AutoLISP Language","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4130.htm"},{"title": "Using AutoLISP to Manipulate AutoCAD Objects","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-48c2.htm"},{"title": "Symbol Table and Dictionary Access","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79ff.htm"},{"title": "Dictionary Entries","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-79fc.htm"}]},
{"title":"Working with Programmable Dialog Boxes",
"href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm",
"description":"",
"ancestors":[]},
{"title":"Designing Dialog Boxes",
"href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4680.htm",
"description":"With dialog control language, you can create dialog boxes.",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"}]},
{"title":"Dialog Box Components",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a7d.htm",
"description":"The following figure shows a standard AutoCAD® dialog box, with some of its components labeled. In dialog box creation and customization these components are known as tiles.",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Designing Dialog Boxes","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4680.htm"}]},
{"title":"Using DCL to Define Dialog Boxes",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a7a.htm",
"description":"You define dialog boxes by entering DCL descriptions in ASCII text files, much like writing AutoLISP code. DCL files have a .dcl extension. A single DCL file can contain the description of one or more dialog boxes, or it can contain only prototype tiles and subassemblies for use by other DCL files. A DCL file consists of the following three parts, which can appear in any order. Depending on your application, only one or more of these parts is required.",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Designing Dialog Boxes","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4680.htm"}]},
{"title":"The base.dcl and acad.dcl Files",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a78.htm",
"description":"The base.dcl and acad.dcl files are included with AutoCAD and are distributed in the User Support folder. To see the path to the User Support folder, from the Tools menu, click Options. On the Files tab, the path to the User Support folder is the first path displayed under Support File Search Path.",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Designing Dialog Boxes","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4680.htm"},{"title": "Using DCL to Define Dialog Boxes","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a7a.htm"}]},
{"title":"Referencing DCL Files",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a77.htm",
"description":"When you create dialog boxes, you must create a new, application-specific DCL file. All DCL files can use the tiles defined in the base.dcl file. A DCL file can also use tiles defined in another DCL file by naming the other file in what is called an include directive. You can create your own hierarchy of DCL files, as shown in the following figure:",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Designing Dialog Boxes","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4680.htm"},{"title": "Using DCL to Define Dialog Boxes","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a7a.htm"}]},
{"title":"DCL Syntax",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a75.htm",
"description":"This section describes the DCL syntax for specifying tiles, tile attributes, and attribute values.",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Designing Dialog Boxes","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4680.htm"},{"title": "Using DCL to Define Dialog Boxes","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a7a.htm"}]},
{"title":"Tile Definitions",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a74.htm",
"description":"Tile definitions have the following form:",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Designing Dialog Boxes","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4680.htm"},{"title": "Using DCL to Define Dialog Boxes","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a7a.htm"},{"title": "DCL Syntax","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a75.htm"}]},
{"title":"Tile References",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a73.htm",
"description":"Tile references have one of the following forms:",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Designing Dialog Boxes","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4680.htm"},{"title": "Using DCL to Define Dialog Boxes","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a7a.htm"},{"title": "DCL Syntax","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a75.htm"}]},
{"title":"Attributes and Attribute Values",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a72.htm",
"description":"Within the curly braces of a tile definition or reference, you specify attributes and assign them values using the following form:",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Designing Dialog Boxes","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4680.htm"},{"title": "Using DCL to Define Dialog Boxes","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a7a.htm"},{"title": "DCL Syntax","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a75.htm"}]},
{"title":"Comments in DCL Files",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a71.htm",
"description":"A statement preceded by two forward slashes (//) is treated as a comment in a DCL file. Anything that appears between the // and the end of the line is ignored. DCL also allows C language style comments. These have the form /*comment text */. The starting /* and ending */ can be on separate lines.",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Designing Dialog Boxes","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4680.htm"},{"title": "Using DCL to Define Dialog Boxes","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a7a.htm"},{"title": "DCL Syntax","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a75.htm"}]},
{"title":"Displaying Dialog Boxes with Visual LISP",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a70.htm",
"description":"VLISP provides a tool for previewing dialog boxes defined with DCL. To see how this works, copy the following DCL code into a new file in the VLISP text editor:",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Designing Dialog Boxes","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4680.htm"}]},
{"title":"Preview Error Handling",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a6c.htm",
"description":"If your DCL code contains errors, the VLISP DCL previewer displays messages indicating the offending line and keyword or symbol. For example, introduce an error into hello.dcl by removing the colon before “button,” then try previewing the dialog box. You\'ll see the following message:",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Designing Dialog Boxes","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4680.htm"},{"title": "Displaying Dialog Boxes with Visual LISP","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a70.htm"}]},
{"title":"Semantic Auditing of DCL Files",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a69.htm",
"description":"AutoCAD provides a choice of four levels (0-3) of semantic auditing for DCL files (see the following table). Auditing attempts to detect code in the DCL file that is likely to be problematic or unnecessary. These audits are done at DCL load time. To set the audit level for a DCL file, include a line such as the following anywhere within the DCL file, but not inside any tile definitions:",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Designing Dialog Boxes","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4680.htm"},{"title": "Displaying Dialog Boxes with Visual LISP","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a70.htm"}]},
{"title":"Adjusting the Layout of Dialog Boxes",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a67.htm",
"description":"Look again at the sample dialog box defined in the previous section. There is a small problem with it:",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Designing Dialog Boxes","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4680.htm"}]},
{"title":"Distributing Tiles in a Cluster",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a64.htm",
"description":"When laying out tiles in a dialog box, you need to arrange them into rows and columns based on the relative size of each tile. The following DCL defines a row of three tiles that runs along the top of another tile:",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Designing Dialog Boxes","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4680.htm"},{"title": "Adjusting the Layout of Dialog Boxes","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a67.htm"}]},
{"title":"Adjusting the Space between Tiles",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a62.htm",
"description":"If two adjoining columns differ greatly in the amount of space their tiles occupy, then the tiles in the one that needs less space may appear to be distributed too far apart. Their appearance can be improved if you set the incongruous column\'s fixed_height attribute to true. The result for vertical tile distribution is shown in the following diagram:",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Designing Dialog Boxes","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4680.htm"},{"title": "Adjusting the Layout of Dialog Boxes","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a67.htm"}]},
{"title":"Adjusting Space at the Right Side or Bottom",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a60.htm",
"description":"A dialog box may contain unused space along its right side. You can define a text tile and explicitly specify a width greater than the width required by its current value. For example, the following code fragment defines a tile that does not display anything (its value is null) until an application sets its value:",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Designing Dialog Boxes","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4680.htm"},{"title": "Adjusting the Layout of Dialog Boxes","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a67.htm"}]},
{"title":"Fixing the Spacing Around a Boxed Row or Column",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a5f.htm",
"description":"If the label attribute of a boxed row or column is either blank (\"\") or null (\"\"), the box encloses the cluster but no text is shown. A single blank does not appear as a space in the box. However, there is a difference in the way blank and null labels are laid out:",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Designing Dialog Boxes","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4680.htm"},{"title": "Adjusting the Layout of Dialog Boxes","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a67.htm"}]},
{"title":"Customizing Exit Button Text",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a5d.htm",
"description":"For some dialog boxes, you may want to change the text of one of the exit buttons. For example, if you create a dialog box capable of destroying data, it\'s safer to call the button Destroy instead of OK. To do this, use the retirement_button prototype as follows:",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Designing Dialog Boxes","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4680.htm"},{"title": "Adjusting the Layout of Dialog Boxes","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a67.htm"}]},
{"title":"Design Guidelines",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a5c.htm",
"description":"To design a dialog box well, you must consider not only the practical purpose of the box but also its aesthetics, the ergonomics of using it, and the GUI standards for the Windows environment. The following subsections provide some guidelines for GUI design, dialog box design, and predefined tiles and clusters. Refer to for more examples of tiles and clusters.",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Designing Dialog Boxes","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4680.htm"}]},
{"title":"Aesthetics and Ergonomics",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a5b.htm",
"description":"The appearance of a dialog box is important. If the box is too cluttered, it is ineffective and hard to use. Also, tiles should be arranged so they are easy to use. Consider which tiles will be used most frequently, make them prominent in the design, and arrange them so it\'s easy to move between them, particularly when they are used in conjunction with each other.",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Designing Dialog Boxes","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4680.htm"},{"title": "Design Guidelines","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a5c.htm"}]},
{"title":"Consistent Design and Clear Language",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a5a.htm",
"description":"The user interface of an application should be internally consistent, and consistent with related applications. An unfamiliar dialog box is easier to understand if its design is consistent with other dialog boxes in the application, related applications, or the host system. One example of this is the consistent placement of buttons such as OK and Cancel. The technique associated with each kind of tile—how you enter text in a text box and how you select a list box item—should also be consistent. The best way to achieve consistency is to reuse tiles and the code that controls them.",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Designing Dialog Boxes","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4680.htm"},{"title": "Design Guidelines","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a5c.htm"}]},
{"title":"User Control",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a59.htm",
"description":"Give users some control over how they access the dialog box to enter input. One advantage of using dialog boxes instead of a command line interface is that boxes don\'t confine users to a strict sequence of prompts. In a dialog box, users should be able to enter input in any sequence. Some constraints are necessary—when selecting one option causes another to be unavailable, for example—but build in only constraints that have underlying reasons in the way your application works.",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Designing Dialog Boxes","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4680.htm"},{"title": "Design Guidelines","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a5c.htm"}]},
{"title":"Forgiving Errors",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a56.htm",
"description":"Make your dialog boxes forgiving, so users feel free to explore without fear of making irreversible mistakes. Report minor errors by messages in an error tile at the bottom of the dialog box. Report more serious errors by displaying an alert box. The alert function displays a simple alert box (with a single OK button). See in the AutoLISP Reference.",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Designing Dialog Boxes","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4680.htm"},{"title": "Design Guidelines","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a5c.htm"}]},
{"title":"Providing Help",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a54.htm",
"description":"You should provide a Help facility. How much Help you provide depends on how complex your application is and how self-explanatory your dialog boxes are. At the very least, it is recommended that the main dialog box of your application have a Help button that displays a single dialog box describing important information. In most cases, the Help button should call the Help facility using the help function.",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Designing Dialog Boxes","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4680.htm"},{"title": "Design Guidelines","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a5c.htm"}]},
{"title":"Users with Disabilities",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a53.htm",
"description":"Considerations intended for users with disabilities can make a program easier for anyone to use. When designing your dialog boxes, consider the following:",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Designing Dialog Boxes","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4680.htm"},{"title": "Design Guidelines","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a5c.htm"}]},
{"title":"Using Capitalization",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a52.htm",
"description":"The following are some general guidelines for capitalizing text within dialog boxes:",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Designing Dialog Boxes","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4680.htm"},{"title": "Design Guidelines","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a5c.htm"}]},
{"title":"Avoiding Abbreviations",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a51.htm",
"description":"Abbreviations can be ambiguous and difficult to translate. If space constraints require you to abbreviate terms, abbreviate them consistently within a group (such as a boxed column). Be consistent. Don\'t spell some terms in full and abbreviate others.",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Designing Dialog Boxes","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4680.htm"},{"title": "Design Guidelines","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a5c.htm"}]},
{"title":"Layout",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a50.htm",
"description":"Arrange sections of the dialog box logically into rows or columns so users can scan them from left to right or from top to bottom. Align related entry fields (such as edit boxes or list boxes) both vertically and horizontally, so that when users switch fields by pressing TAB, the cursor moves in a straight, orthogonal line.",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Designing Dialog Boxes","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4680.htm"},{"title": "Design Guidelines","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a5c.htm"}]},
{"title":"Size and Placement",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a4f.htm",
"description":"To display information clearly, make the dialog box no larger than necessary.",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Designing Dialog Boxes","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4680.htm"},{"title": "Design Guidelines","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a5c.htm"}]},
{"title":"Disabling Tiles",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a4e.htm",
"description":"If a tile or an area is unavailable or irrelevant given the current option settings, disable it immediately so the tile or area is unavailable and the user can\'t select it. Try not to overuse the disabling tiles feature. Too many unavailable tiles can be distracting.",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Designing Dialog Boxes","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4680.htm"},{"title": "Design Guidelines","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a5c.htm"}]},
{"title":"Nesting Dialog Boxes",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a4d.htm",
"description":"AutoCAD limits the number of nested dialog boxes to eight. For information on how to handle nested dialog boxes, see .",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Designing Dialog Boxes","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4680.htm"},{"title": "Design Guidelines","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a5c.htm"}]},
{"title":"Closing a Dialog Box for User Selection",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a4c.htm",
"description":"If a user needs to make a selection from the graphics screen before the dialog box has closed, you must close the dialog box momentarily so that the user can see the screen and make the selection. This is known as hiding a dialog box. Once the selection is made, you need to display the dialog box again.",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Designing Dialog Boxes","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4680.htm"},{"title": "Design Guidelines","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a5c.htm"}]},
{"title":"Providing Defaults",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a4b.htm",
"description":"Provide reasonable defaults for all entries and options. Well-chosen defaults can help users complete a dialog box quickly and easily.",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Designing Dialog Boxes","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4680.htm"},{"title": "Design Guidelines","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a5c.htm"}]},
{"title":"Handling Keyboard Input",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a4a.htm",
"description":"When you create a custom dialog box, you can specify how it handles keyboard shortcuts. Some keyboard shortcuts are common to all dialog boxes. For example, the TAB key generally enables users to move from tile to tile, and the SPACEBAR allows users to turn toggles off or on. Each active tile should be a tab stop (the default).",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Designing Dialog Boxes","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4680.htm"},{"title": "Design Guidelines","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a5c.htm"}]},
{"title":"International Language Considerations",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a49.htm",
"description":"Words in other languages often require more characters than their English equivalents. If your dialog boxes are going to be translated, leave as much room as possible for them to grow. The following table shows some familiar AutoCAD terms with their equivalents in French and German.",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Designing Dialog Boxes","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4680.htm"},{"title": "Design Guidelines","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a5c.htm"}]},
{"title":"Guidelines for Predefined Tiles and Clusters",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a47.htm",
"description":"This section lists recommended conventions and design guidelines associated with particular kinds of predefined tiles and tile clusters.",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Designing Dialog Boxes","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4680.htm"},{"title": "Design Guidelines","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a5c.htm"}]},
{"title":"Buttons",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a46.htm",
"description":"The action associated with a button should be visible to the user and should take place immediately. The label of a button should be unambiguous. Usually, it should be a verb that describes the effect of pushing the button, though another label—such as OK or Options—is acceptable if its meaning is clear. For buttons that call other dialog boxes or hide the current dialog box, see and .",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Designing Dialog Boxes","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4680.htm"},{"title": "Design Guidelines","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a5c.htm"},{"title": "Guidelines for Predefined Tiles and Clusters","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a47.htm"}]},
{"title":"Clusters",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a45.htm",
"description":"A boxed cluster (a row or column) is called a group box or an area. An area provides a visual cue to users by isolating and naming controls that work together. The area can contain as many tiles, rows, and columns (unboxed) as necessary. The label of an area should indicate its purpose.",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Designing Dialog Boxes","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4680.htm"},{"title": "Design Guidelines","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a5c.htm"},{"title": "Guidelines for Predefined Tiles and Clusters","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a47.htm"}]},
{"title":"Edit Boxes",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a43.htm",
"description":"The length of the text-entry portion of an edit box should roughly equal the length of an average entry. When in doubt, use a character width of 10 for real number fields and 20 for text fields.",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Designing Dialog Boxes","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4680.htm"},{"title": "Design Guidelines","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a5c.htm"},{"title": "Guidelines for Predefined Tiles and Clusters","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a47.htm"}]},
{"title":"Image Buttons and Image Tiles",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a41.htm",
"description":"If you use an image button or image tile as an icon to alert the user—for example, a warning signal such as a stop sign—use it consistently in all dialog boxes.",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Designing Dialog Boxes","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4680.htm"},{"title": "Design Guidelines","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a5c.htm"},{"title": "Guidelines for Predefined Tiles and Clusters","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a47.htm"}]},
{"title":"List Boxes",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a40.htm",
"description":"Because DCL list boxes cannot be scrolled horizontally, the width of the list box should accommodate the longest item in the list. Provide a label (or a text tile) to explain the contents of the list box, unless the list box is the main tile in the dialog box. In that case the dialog box\'s label might be sufficient—although you must give the list box a label if you want users to be able to move to that list box by using a mnemonic.",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Designing Dialog Boxes","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4680.htm"},{"title": "Design Guidelines","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a5c.htm"},{"title": "Guidelines for Predefined Tiles and Clusters","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a47.htm"}]},
{"title":"Radio Buttons, Radio Rows, and Radio Columns",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a3f.htm",
"description":"Radio columns look better and are easier to use than radio rows.",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Designing Dialog Boxes","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4680.htm"},{"title": "Design Guidelines","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a5c.htm"},{"title": "Guidelines for Predefined Tiles and Clusters","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a47.htm"}]},
{"title":"Sliders",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a3d.htm",
"description":"The granularity of a slider should not be too coarse. For example, if a slider is assigned only four incremental values but is laid out in a two-inch section of the dialog box, users would have to move half an inch to see a change. Avoid jumpiness like this by scaling the size of the slider.",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Designing Dialog Boxes","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4680.htm"},{"title": "Design Guidelines","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a5c.htm"},{"title": "Guidelines for Predefined Tiles and Clusters","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a47.htm"}]},
{"title":"Text",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a3b.htm",
"description":"When labels are not sufficient, use text tiles to identify the purpose of individual tiles or dialog box areas. You can also use text tiles to display status messages or reminders, including error messages and warnings.",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Designing Dialog Boxes","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4680.htm"},{"title": "Design Guidelines","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a5c.htm"},{"title": "Guidelines for Predefined Tiles and Clusters","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a47.htm"}]},
{"title":"Toggles",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a3a.htm",
"description":"When the options controlled by toggles relate to the same topic, group them together.",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Designing Dialog Boxes","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4680.htm"},{"title": "Design Guidelines","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a5c.htm"},{"title": "Guidelines for Predefined Tiles and Clusters","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a47.htm"}]},
{"title":"Error Handling in Dialog Boxes",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a38.htm",
"description":"Dialog boxes can display error messages and warnings with a text tile known as an error tile (errtile), or with a nested alert box. The following guidelines apply to both:",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Designing Dialog Boxes","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4680.htm"},{"title": "Design Guidelines","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a5c.htm"}]},
{"title":"Error Tiles",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a36.htm",
"description":"Use an error tile for minor errors or warnings, especially those that arise from typographical errors.",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Designing Dialog Boxes","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4680.htm"},{"title": "Design Guidelines","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a5c.htm"},{"title": "Error Handling in Dialog Boxes","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a38.htm"}]},
{"title":"Alert Boxes",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a35.htm",
"description":"You can display a standard alert box with a single OK button by calling the alert function. Use alert boxes for serious or potentially fatal errors, but do not overuse them. Alert boxes require user input. Therefore, they can be annoying, especially when they report minor errors or obscure the entry that needs to be corrected.",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Designing Dialog Boxes","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4680.htm"},{"title": "Design Guidelines","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a5c.htm"},{"title": "Error Handling in Dialog Boxes","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a38.htm"}]},
{"title":"Managing Dialog Boxes",
"href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-5d1e.htm",
"description":"You can use dialog boxes to respond to user input.",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"}]},
{"title":"Controlling Dialog Boxes with AutoLISP Programs",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7aac.htm",
"description":"This chapter begins with an overview of the process you use to display dialog boxes and respond to user input from an AutoLISP program.",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Managing Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-5d1e.htm"}]},
{"title":"Quick Overview",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7aab.htm",
"description":"This example starts with a simple dialog box:",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Managing Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-5d1e.htm"},{"title": "Controlling Dialog Boxes with AutoLISP Programs","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7aac.htm"}]},
{"title":"Functions Restricted When a Dialog Box Is Open",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7aa7.htm",
"description":"While a dialog box is active—that is, during the start_dialog call—you cannot call any function that requires user input on the AutoCAD command line, or affects the display outside the dialog box (for example, in the AutoCAD graphics window). This restriction includes functions that write text, such as print, princ, and prin1.",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Managing Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-5d1e.htm"},{"title": "Controlling Dialog Boxes with AutoLISP Programs","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7aac.htm"}]},
{"title":"Action Expressions and Callbacks",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7aa6.htm",
"description":"To define the action taken when a certain tile in a dialog box is selected, you associate an AutoLISP expression with that tile by calling the action_tile function. This is known as an action expression. Within the action expression, you often need access to attributes in the DCL file. The get_tile and get_attr functions provide this capability. The get_attr function retrieves the user-defined attributes within the DCL file. The get_tile function gets the current runtime value of a tile based on user input to that tile. Action expressions must be defined following the new_dialog call and before the start_dialog call.",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Managing Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-5d1e.htm"}]},
{"title":"Action Expressions",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7aa5.htm",
"description":"An action expression can access the variables shown in the following table, indicate which tile was selected, and describe the tile\'s state at the time of the action. The variable names are reserved. Their values are read-only and have no meaning, unless they are accessed within an action expression.",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Managing Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-5d1e.htm"},{"title": "Action Expressions and Callbacks","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7aa6.htm"}]},
{"title":"Callback Reasons",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7aa3.htm",
"description":"The callback reason, returned in the $reason variable, specifies why the action occurred. Its value is set for any kind of action, but you need to inspect it only when the action is associated with an edit_box, list_box, image_button, or slider tile. The following table shows the possible values:",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Managing Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-5d1e.htm"},{"title": "Action Expressions and Callbacks","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7aa6.htm"}]},
{"title":"Default and DCL Actions",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a9d.htm",
"description":"The action_tile function is not the only way to specify an action. A tile\'s DCL description can include an action attribute in AutoLISP, and the new_dialog call can specify a default action for the dialog box as a whole. A tile can have only a single action at a time. If the DCL and the application specify more than one action, they supersede each other in the following order of priority (lowest to highest):",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Managing Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-5d1e.htm"},{"title": "Action Expressions and Callbacks","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7aa6.htm"},{"title": "Callback Reasons","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7aa3.htm"}]},
{"title":"Handling Tiles",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a9b.htm",
"description":"Your program has some control over the tiles that are in the current dialog box at initialization time and action (callback) time. This section introduces the tile-handling functions and shows how to initialize and modify the tiles\' modes and values.",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Managing Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-5d1e.htm"}]},
{"title":"Initializing Modes and Values",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a9a.htm",
"description":"Initializing a tile can include the following:",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Managing Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-5d1e.htm"},{"title": "Handling Tiles","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a9b.htm"}]},
{"title":"Changing Modes and Values at Callback Time",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a98.htm",
"description":"At callback time, you can check the value of a tile. If necessary, you can use set_tile again to modify this value. During callbacks, you can also use mode_tile to change the status of a tile. The following table shows the values of the mode_tilemode argument:",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Managing Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-5d1e.htm"},{"title": "Handling Tiles","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a9b.htm"}]},
{"title":"Handling Radio Clusters",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a96.htm",
"description":"Radio buttons appear in radio clusters. The value of each radio button is either \"1\" for On or \"0\" for Off. The value of the radio cluster is the key attribute of the currently selected button. The PDB feature manages the values of radio buttons in a cluster and ensures that only one button is turned on at a time. You can assign an action to each radio button, but it is more convenient to assign an action to the radio cluster as a whole and then test the cluster\'s value to see which radio button was chosen.",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Managing Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-5d1e.htm"},{"title": "Handling Tiles","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a9b.htm"}]},
{"title":"Handling Sliders",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a95.htm",
"description":"When you handle actions and callbacks from sliders, your application should check the reason code that it receives along with the callback. This is not required, but it is a good idea because it can reduce processing.",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Managing Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-5d1e.htm"},{"title": "Handling Tiles","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a9b.htm"}]},
{"title":"Handling Edit Boxes",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a94.htm",
"description":"Actions and callbacks to handle edit boxes are similar to those for sliders. However, because characters in edit boxes are already visible, there is no need for action on interim results. Edit boxes only return a callback code when the focus to that tile is lost. The following code example checks the value but doesn\'t redisplay it:",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Managing Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-5d1e.htm"},{"title": "Handling Tiles","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a9b.htm"}]},
{"title":"Nesting Dialog Boxes",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a93.htm",
"description":"You create and manage nested dialog boxes by calling new_dialog and start_dialog from within an action expression or callback function. For example, by including the following statement, a function can display the “Hello, world” box when the user chooses the button called button_1:",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Managing Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-5d1e.htm"}]},
{"title":"Functions for Hiding Dialog Boxes",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a92.htm",
"description":"A user cannot make an interactive selection while a dialog box is active. If you want the user to make a selection from the graphics screen, you must hide your dialog box and then restore it. Hiding the box is the same as ending it with done_dialog, except your callback function must use the done_dialog status argument to indicate that the dialog box is hidden—as opposed to ended or canceled. Set status to an application-defined value.",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Managing Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-5d1e.htm"}]},
{"title":"Requesting a Password",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a90.htm",
"description":"The following examples show how to use a simple dialog box to request a password from users.",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Managing Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-5d1e.htm"},{"title": "Functions for Hiding Dialog Boxes","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a92.htm"}]},
{"title":"List Boxes and Pop-Up Lists",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a8f.htm",
"description":"The following functions handle list boxes and pop-up lists in dialog boxes:",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Managing Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-5d1e.htm"}]},
{"title":"List Operations",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a8d.htm",
"description":"A dialog box list operation always begins with a start_list function call. The function syntax is as follows:",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Managing Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-5d1e.htm"},{"title": "List Boxes and Pop-Up Lists","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a8f.htm"}]},
{"title":"Processing List Elements",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a8b.htm",
"description":"Because the value of a list_box tile can contain leading spaces (especially if you are retrieving multiple items), do not test the value as a string comparison. Convert list_box value to an integer first with the atoi function, before processing the list box. You can also use the read function, which converts a token to an integer automatically. For example, for a list named justone that accepts only a single selection, the following code fragment checks to see if the third item in the list was selected:",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Managing Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-5d1e.htm"},{"title": "List Boxes and Pop-Up Lists","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a8f.htm"}]},
{"title":"Image Tiles and Buttons",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a8a.htm",
"description":"AutoLISP provides functions for handling image tiles and image buttons. Examples for how to use these functions are provided in this section.",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Managing Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-5d1e.htm"}]},
{"title":"Creating Images",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a89.htm",
"description":"The calling sequence to create images for image tiles and image buttons is similar to the list-handling sequence. The start_image function begins the creation of an image, and end_image ends it. However, the type of image to draw is specified in separate function calls, instead of arguments:",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Managing Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-5d1e.htm"},{"title": "Image Tiles and Buttons","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a8a.htm"}]},
{"title":"Handling Image Buttons",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a87.htm",
"description":"You can handle an image button simply as a button—that is, you can use it to trigger a single action. However, you can also use the PDB feature to define regions of the button. With regions defined, the action taken depends on the part of the image button the user selects. The mechanism for this is straightforward: an image button\'s action or callback returns the (X,Y) location that the user selected. The coordinates are within the range of the particular image button tile (as returned by the dimension functions). Your application must assign a meaning to select locations by implicitly defining regions of the image. The DDVPOINT dialog box makes good use of this feature. You can view this by loading and running the ddvpoint.lsp file in the AutoCAD Support directory.",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Managing Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-5d1e.htm"},{"title": "Image Tiles and Buttons","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a8a.htm"}]},
{"title":"Application-Specific Data",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a86.htm",
"description":"The client_data_tile function assigns application-specific data to a tile. The data is available at callback time as the $data variable and must be a string. Client data is not represented in DCL; it is valid only while your application is running. Using client data is comparable to using user-defined attributes. The main difference is that user-defined attributes are read-only, while client data can change at runtime. Also, end-users can inspect user-defined attributes in the application\'s DCL file, but client data is invisible to them.",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Managing Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-5d1e.htm"}]},
{"title":"DCL Error Handling",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a85.htm",
"description":"The PDB feature checks a DCL file for errors the first time you load it. If AutoCAD encounters a syntax error, a misuse of attributes, or any other error (such as failure to specify a key attribute for an active tile), the PDB does not load the DCL file. Instead, AutoCAD either displays one or more dialog boxes alerting you to the error, or writes a list of errors to a text file called acad.dce. If AutoCAD writes the error messages to acad.dce, it alerts you to this with a message similar to the following:",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Managing Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-5d1e.htm"}]},
{"title":"Setting the Auditing Level to Affect Error Messages",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a83.htm",
"description":"The level of semantic auditing affects which messages AutoCAD issues for a DCL file (see ). For example, the hidedcl dialog box defined in is displayed without any warnings, if you use the default audit level. If you set the audit level to 3, though, AutoCAD displays an alert dialog box with a warning message. You can see this for yourself by inserting the following line at the beginning of hidedcl:",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Managing Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-5d1e.htm"},{"title": "DCL Error Handling","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a85.htm"}]},
{"title":"Dialog Box Function Summary",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a82.htm",
"description":"This section summarizes the steps required in a typical dialog box handling function. It also describes a sample application you can refer to when designing and implementing your own dialog box functions.",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Managing Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-5d1e.htm"}]},
{"title":"Function Sequence",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a81.htm",
"description":"The following demonstrates the typical function sequence:",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Managing Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-5d1e.htm"},{"title": "Dialog Box Function Summary","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a82.htm"}]},
{"title":"The Sample Block Definition Dialog Box",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a7f.htm",
"description":"The sample application bmake.lsp and its associated bmake.dcl file illustrate a number of useful dialog box techniques. These files are in the AutoCAD Support directory. The bmake application is essentially an interactive interface to the entmake function. You can use it to define new blocks and to view the names of existing blocks. Some of the techniques illustrated by bmake are",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Managing Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-5d1e.htm"},{"title": "Dialog Box Function Summary","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7a82.htm"}]},
{"title":"Programmable Dialog Box Reference",
"href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-44ba.htm",
"description":"You can use attributes to work with dialog boxes.",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"}]},
{"title":"Tile Attributes",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b26.htm",
"description":"A tile\'s attributes define its layout and functionality. An attribute is similar to a programming language variable: it consists of a name and a value.",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Programmable Dialog Box Reference","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-44ba.htm"}]},
{"title":"Attribute Types",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b25.htm",
"description":"The value of an attribute must be one of the following data types:",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Programmable Dialog Box Reference","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-44ba.htm"},{"title": "Tile Attributes","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b26.htm"}]},
{"title":"Restricted Attributes",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b23.htm",
"description":"The following tile attributes are restricted. Do not use them in your DCL files:",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Programmable Dialog Box Reference","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-44ba.htm"},{"title": "Tile Attributes","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b26.htm"}]},
{"title":"User-Defined Attributes",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b21.htm",
"description":"When defining tiles, you can assign your own attributes. The name of the attribute can be any valid name that does not conflict with the standard, predefined attributes described in and summarized in . An attribute name, like a keyword, can contain letters, numbers, or the underscore (_), and must begin with a letter.",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Programmable Dialog Box Reference","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-44ba.htm"},{"title": "Tile Attributes","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b26.htm"}]},
{"title":"Synopsis of Predefined Attributes",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b20.htm",
"description":"This section lists the attributes defined by the PDB feature. The following table summarizes the predefined attributes in alphabetical order. The attributes are described in detail in .",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Programmable Dialog Box Reference","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-44ba.htm"}]},
{"title":"DCL Attribute Catalog",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b1e.htm",
"description":"DCL tile attributes are described in detail in this section. The attributes are listed alphabetically.",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Programmable Dialog Box Reference","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-44ba.htm"}]},
{"title":"action",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b1d.htm",
"description":"action = \"(function)\";",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Programmable Dialog Box Reference","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-44ba.htm"}]},
{"title":"alignment",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b1c.htm",
"description":"alignment = position;",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Programmable Dialog Box Reference","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-44ba.htm"}]},
{"title":"allow_accept",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b1b.htm",
"description":"allow_accept = true-false;",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Programmable Dialog Box Reference","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-44ba.htm"}]},
{"title":"aspect_ratio",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b1a.htm",
"description":"aspect_ratio = real;",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Programmable Dialog Box Reference","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-44ba.htm"}]},
{"title":"big_increment",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b19.htm",
"description":"big_increment = integer;",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Programmable Dialog Box Reference","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-44ba.htm"}]},
{"title":"children_alignment",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b18.htm",
"description":"children_alignment = position;",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Programmable Dialog Box Reference","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-44ba.htm"}]},
{"title":"children_fixed_height",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b17.htm",
"description":"children_fixed_height = true-false;",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Programmable Dialog Box Reference","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-44ba.htm"}]},
{"title":"children_fixed_width",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b16.htm",
"description":"children_fixed_width = true-false;",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Programmable Dialog Box Reference","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-44ba.htm"}]},
{"title":"color",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b15.htm",
"description":"color = colorname;",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Programmable Dialog Box Reference","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-44ba.htm"}]},
{"title":"edit_limit",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b13.htm",
"description":"edit_limit = integer;",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Programmable Dialog Box Reference","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-44ba.htm"}]},
{"title":"edit_width",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b12.htm",
"description":"edit_width = number;",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Programmable Dialog Box Reference","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-44ba.htm"}]},
{"title":"fixed_height",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b11.htm",
"description":"fixed_height = true-false;",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Programmable Dialog Box Reference","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-44ba.htm"}]},
{"title":"fixed_width",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b10.htm",
"description":"fixed_width = true-false;",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Programmable Dialog Box Reference","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-44ba.htm"}]},
{"title":"fixed_width_font",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b0f.htm",
"description":"fixed_width_font = true-false;",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Programmable Dialog Box Reference","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-44ba.htm"}]},
{"title":"height",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b0e.htm",
"description":"height = number;",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Programmable Dialog Box Reference","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-44ba.htm"}]},
{"title":"initial_focus",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b0d.htm",
"description":"initial_focus = \"string\";",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Programmable Dialog Box Reference","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-44ba.htm"}]},
{"title":"is_bold",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b0c.htm",
"description":"is_bold = true-false;",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Programmable Dialog Box Reference","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-44ba.htm"}]},
{"title":"is_cancel",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b0b.htm",
"description":"is_cancel = true-false;",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Programmable Dialog Box Reference","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-44ba.htm"}]},
{"title":"is_default",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b0a.htm",
"description":"is_default = true-false;",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Programmable Dialog Box Reference","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-44ba.htm"}]},
{"title":"is_enabled",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b09.htm",
"description":"is_enabled = true-false;",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Programmable Dialog Box Reference","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-44ba.htm"}]},
{"title":"is_tab_stop",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b08.htm",
"description":"is_tab_stop = true-false;",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Programmable Dialog Box Reference","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-44ba.htm"}]},
{"title":"key",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b07.htm",
"description":"key = \"string\";",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Programmable Dialog Box Reference","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-44ba.htm"}]},
{"title":"label",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b06.htm",
"description":"label = \"string\";",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Programmable Dialog Box Reference","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-44ba.htm"}]},
{"title":"layout",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b05.htm",
"description":"layout = position;",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Programmable Dialog Box Reference","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-44ba.htm"}]},
{"title":"list",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b04.htm",
"description":"list = \"string\";",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Programmable Dialog Box Reference","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-44ba.htm"}]},
{"title":"max_value",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b03.htm",
"description":"max_value = integer;",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Programmable Dialog Box Reference","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-44ba.htm"}]},
{"title":"min_value",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b02.htm",
"description":"min_value = integer;",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Programmable Dialog Box Reference","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-44ba.htm"}]},
{"title":"mnemonic",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b01.htm",
"description":"mnemonic = \"char\";",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Programmable Dialog Box Reference","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-44ba.htm"}]},
{"title":"multiple_select",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b00.htm",
"description":"multiple_select = true-false;",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Programmable Dialog Box Reference","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-44ba.htm"}]},
{"title":"password_char",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7aff.htm",
"description":"password_char = \"char\";",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Programmable Dialog Box Reference","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-44ba.htm"}]},
{"title":"small_increment",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7afe.htm",
"description":"small_increment = integer;",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Programmable Dialog Box Reference","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-44ba.htm"}]},
{"title":"tabs",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7afd.htm",
"description":"tabs = \"string\";",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Programmable Dialog Box Reference","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-44ba.htm"}]},
{"title":"tab_truncate",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7afc.htm",
"description":"tab_truncate = true-false;",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Programmable Dialog Box Reference","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-44ba.htm"}]},
{"title":"value",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7afb.htm",
"description":"value = \"string\";",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Programmable Dialog Box Reference","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-44ba.htm"}]},
{"title":"width",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7afa.htm",
"description":"width = number;",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Programmable Dialog Box Reference","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-44ba.htm"}]},
{"title":"Functional Synopsis of DCL Tiles",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7af9.htm",
"description":"This section presents the DCL tiles in functional groupings.",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Programmable Dialog Box Reference","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-44ba.htm"}]},
{"title":"Predefined Active Tiles",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7af8.htm",
"description":"The AutoCAD PDB feature has a set of built-in, or predefined, tiles that can be used by themselves or as the basis for more complex tiles. Their definitions appear as comments within the base.dcl file. (See .)",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Programmable Dialog Box Reference","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-44ba.htm"},{"title": "Functional Synopsis of DCL Tiles","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7af9.htm"}]},
{"title":"Tile Clusters",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7af6.htm",
"description":"You can group tiles into composite rows or columns (known collectively as clusters). For layout purposes, a cluster is treated as a single tile. The row or column can be boxed, with an optional label (a cluster without a box cannot be labeled).",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Programmable Dialog Box Reference","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-44ba.htm"},{"title": "Functional Synopsis of DCL Tiles","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7af9.htm"}]},
{"title":"Decorative and Informative Tiles",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7af4.htm",
"description":"The tiles listed below do not cause actions and cannot be selected. They are provided to display information or for visual emphasis, or to assist you in laying out the dialog box.",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Programmable Dialog Box Reference","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-44ba.htm"},{"title": "Functional Synopsis of DCL Tiles","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7af9.htm"}]},
{"title":"Text Clusters",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7af2.htm",
"description":"A text tile is surrounded by margin space (like any other kind of tile), which presents a problem when you want to combine pieces of text. For example, assume you want to display the following message:",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Programmable Dialog Box Reference","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-44ba.htm"},{"title": "Functional Synopsis of DCL Tiles","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7af9.htm"}]},
{"title":"Dialog Box Exit Buttons and Error Tiles",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7af1.htm",
"description":"The base.dcl file provides standard button subassemblies for exiting (or “retiring”) a dialog box. Use these standard versions to maintain a consistent appearance across applications.",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Programmable Dialog Box Reference","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-44ba.htm"},{"title": "Functional Synopsis of DCL Tiles","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7af9.htm"}]},
{"title":"Restricted Tiles",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7af0.htm",
"description":"Your DCL files should not use the tiles cluster or tile. Also, do not use the basic exit button types (cancel_button, help_button, info_button, and ok_button) unless you redefine the standard exit button subassemblies as described in .",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Programmable Dialog Box Reference","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-44ba.htm"},{"title": "Functional Synopsis of DCL Tiles","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7af9.htm"}]},
{"title":"DCL Tile Catalog",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7aef.htm",
"description":"This section describes all the predefined DCL tiles. The syntax statement, which follows the tile name, lists all the attributes associated with that tile. Any specific attribute functionality is noted following the tile\'s description.",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Programmable Dialog Box Reference","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-44ba.htm"}]},
{"title":"boxed_column",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7aee.htm",
"description":": boxed_column { alignment children_alignment  children_fixed_height children_fixed_width  fixed_height fixed_width height label width }",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Programmable Dialog Box Reference","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-44ba.htm"}]},
{"title":"boxed_radio_column",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7aec.htm",
"description":"",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Programmable Dialog Box Reference","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-44ba.htm"}]},
{"title":"boxed_radio_row",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7aea.htm",
"description":"",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Programmable Dialog Box Reference","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-44ba.htm"}]},
{"title":"boxed_row",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7ae8.htm",
"description":"",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Programmable Dialog Box Reference","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-44ba.htm"}]},
{"title":"button",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7ae6.htm",
"description":": button { action alignment fixed_height fixed_width height is_cancel is_default is_enabled is_tab_stop key label mnemonic width }",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Programmable Dialog Box Reference","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-44ba.htm"}]},
{"title":"column",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7ae4.htm",
"description":": column { alignment children_alignment  children_fixed_height children_fixed_width  fixed_height fixed_width height label width }",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Programmable Dialog Box Reference","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-44ba.htm"}]},
{"title":"concatenation",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7ae2.htm",
"description":": concatenation {}",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Programmable Dialog Box Reference","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-44ba.htm"}]},
{"title":"dialog",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7ae1.htm",
"description":": dialog { initial_focus label value }",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Programmable Dialog Box Reference","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-44ba.htm"}]},
{"title":"edit_box",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7ae0.htm",
"description":": edit_box { action alignment allow_accept edit_limit  edit_width fixed_height fixed_width height  is_enabled is_tab_stop key label mnemonic  value width password_char}",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Programmable Dialog Box Reference","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-44ba.htm"}]},
{"title":"errtile",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7ade.htm",
"description":"errtile;",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Programmable Dialog Box Reference","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-44ba.htm"}]},
{"title":"image",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7add.htm",
"description":": image { action alignment aspect_ratio color  fixed_height fixed_width height is_enabled  is_tab_stop key mnemonic value width }",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Programmable Dialog Box Reference","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-44ba.htm"}]},
{"title":"image_button",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7adb.htm",
"description":": image_button { action alignment allow_accept aspect_ratio  color fixed_height fixed_width height  is_enabled is_tab_stop key mnemonic width }",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Programmable Dialog Box Reference","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-44ba.htm"}]},
{"title":"list_box",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7ad9.htm",
"description":": list_box { action alignment allow_accept fixed_height  fixed_width height is_enabled is_tab_stop  key label list mnemonic multiple_select tabs value width }",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Programmable Dialog Box Reference","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-44ba.htm"}]},
{"title":"ok_only",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7ad7.htm",
"description":"ok_only;",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Programmable Dialog Box Reference","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-44ba.htm"}]},
{"title":"ok_cancel",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7ad5.htm",
"description":"ok_cancel;",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Programmable Dialog Box Reference","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-44ba.htm"}]},
{"title":"ok_cancel_help",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7ad3.htm",
"description":"ok_cancel_help;",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Programmable Dialog Box Reference","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-44ba.htm"}]},
{"title":"ok_cancel_help_errtile",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7ad1.htm",
"description":"ok_cancel_help_errtile;",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Programmable Dialog Box Reference","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-44ba.htm"}]},
{"title":"ok_cancel_help_info",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7acf.htm",
"description":"ok_cancel_help_info;",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Programmable Dialog Box Reference","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-44ba.htm"}]},
{"title":"paragraph",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7acd.htm",
"description":": paragraph {}",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Programmable Dialog Box Reference","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-44ba.htm"}]},
{"title":"popup_list",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7acb.htm",
"description":": popup_list { action alignment edit_width fixed_height  fixed_width height is_enabled is_tab_stop  key label list mnemonic tabs value width }",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Programmable Dialog Box Reference","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-44ba.htm"}]},
{"title":"radio_button",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7ac9.htm",
"description":": radio_button { action alignment fixed_height fixed_width  height is_enabled is_tab_stop key label  mnemonic value width }",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Programmable Dialog Box Reference","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-44ba.htm"}]},
{"title":"radio_column",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7ac7.htm",
"description":": radio_column { alignment children_alignment  children_fixed_height children_fixed_width  fixed_height fixed_width height label width }",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Programmable Dialog Box Reference","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-44ba.htm"}]},
{"title":"radio_row",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7ac5.htm",
"description":": radio_row { alignment children_alignment  children_fixed_height children_fixed_width  fixed_height fixed_width height label width }",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Programmable Dialog Box Reference","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-44ba.htm"}]},
{"title":"row",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7ac3.htm",
"description":": row { alignment children_alignment  children_fixed_height children_fixed_width  fixed_height fixed_width height label width }",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Programmable Dialog Box Reference","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-44ba.htm"}]},
{"title":"slider",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7ac2.htm",
"description":": slider { action alignment big_increment fixed_height  fixed_width height key label layout  max_value min_value mnemonic small_increment  value width}",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Programmable Dialog Box Reference","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-44ba.htm"}]},
{"title":"text",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7ac0.htm",
"description":": text { alignment fixed_height fixed_width height  is_bold key label value width}",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Programmable Dialog Box Reference","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-44ba.htm"}]},
{"title":"text_part",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7abf.htm",
"description":": text_part { label}",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Programmable Dialog Box Reference","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-44ba.htm"}]},
{"title":"toggle",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7abe.htm",
"description":": toggle { action alignment fixed_height fixed_width  height is_enabled is_tab_stop label width }",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Programmable Dialog Box Reference","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-44ba.htm"}]},
{"title":"spacer",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7abc.htm",
"description":": spacer { alignment fixed_height fixed_width  height width }",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Programmable Dialog Box Reference","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-44ba.htm"}]},
{"title":"spacer_0",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7abb.htm",
"description":"spacer_0;",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Programmable Dialog Box Reference","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-44ba.htm"}]},
{"title":"spacer_1",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7ab9.htm",
"description":"spacer_1;",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Programmable Dialog Box Reference","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-44ba.htm"}]},
{"title":"Programmable Dialog Box Function Synopsis",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7ab7.htm",
"description":"The programmable dialog box functions perform dialog box opening and closing, tile and attribute handling, list box and pop-up list handling, image tile handling, and application-specific data handling. This section lists each PDB function available in Visual LISP, grouping them by the type of task each performs. For detailed information on these functions, see the AutoLISP Reference.",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Programmable Dialog Box Reference","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-44ba.htm"}]},
{"title":"Dialog Box Opening and Closing Functions",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7ab6.htm",
"description":"The following table provides summary descriptions of the DCL opening and closing functions.",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Programmable Dialog Box Reference","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-44ba.htm"},{"title": "Programmable Dialog Box Function Synopsis","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7ab7.htm"}]},
{"title":"Tile- and Attribute-Handling Functions",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7ab4.htm",
"description":"The following table provides summary descriptions of the DCL tile- and attribute-handling functions.",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Programmable Dialog Box Reference","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-44ba.htm"},{"title": "Programmable Dialog Box Function Synopsis","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7ab7.htm"}]},
{"title":"List Box and Pop-Up List-Handling Functions",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7ab2.htm",
"description":"The following table provides summary descriptions of the DCL list box and pop-up list-handling functions.",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Programmable Dialog Box Reference","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-44ba.htm"},{"title": "Programmable Dialog Box Function Synopsis","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7ab7.htm"}]},
{"title":"Image Tile-Handling Functions",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7ab0.htm",
"description":"The following table provides summary descriptions of the DCL image tile-handling functions.",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Programmable Dialog Box Reference","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-44ba.htm"},{"title": "Programmable Dialog Box Function Synopsis","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7ab7.htm"}]},
{"title":"Application-Specific Data-Handling Function",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7aae.htm",
"description":"The following table provides a summary description of the DCL application-specific data-handling function.",
"ancestors":[{"title": "Working with Programmable Dialog Boxes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591b.htm"},{"title": "Programmable Dialog Box Reference","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-44ba.htm"},{"title": "Programmable Dialog Box Function Synopsis","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7ab7.htm"}]},
{"title":"Appendixes",
"href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591a.htm",
"description":"",
"ancestors":[]},
{"title":"AutoLISP Function Synopsis",
"href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4275.htm",
"description":"Functions are categorized and described.",
"ancestors":[{"title": "Appendixes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591a.htm"}]},
{"title":"Category Summary",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b6d.htm",
"description":"Functions in this synopsis are organized into the following categories:",
"ancestors":[{"title": "Appendixes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591a.htm"},{"title": "AutoLISP Function Synopsis","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4275.htm"}]},
{"title":"Basic Functions",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b6a.htm",
"description":"The basic functions consist of the arithmetic, string-handling, equality and conditional, list manipulation, symbol-handling, function-handling, error-handling, and application-handling functions.",
"ancestors":[{"title": "Appendixes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591a.htm"},{"title": "AutoLISP Function Synopsis","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4275.htm"}]},
{"title":"Application-Handling Functions",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b69.htm",
"description":"The following table provides summary descriptions of the AutoLISP application-handling functions.",
"ancestors":[{"title": "Appendixes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591a.htm"},{"title": "AutoLISP Function Synopsis","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4275.htm"},{"title": "Basic Functions","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b6a.htm"}]},
{"title":"Arithmetic Functions",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b67.htm",
"description":"The following table provides summary descriptions of the AutoLISP arithmetic functions.",
"ancestors":[{"title": "Appendixes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591a.htm"},{"title": "AutoLISP Function Synopsis","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4275.htm"},{"title": "Basic Functions","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b6a.htm"}]},
{"title":"Equality and Conditional Functions",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b65.htm",
"description":"The following table provides summary descriptions of the AutoLISP equality and conditional functions.",
"ancestors":[{"title": "Appendixes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591a.htm"},{"title": "AutoLISP Function Synopsis","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4275.htm"},{"title": "Basic Functions","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b6a.htm"}]},
{"title":"Error-Handling Functions",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b63.htm",
"description":"The following table provides summary descriptions of the AutoLISP error-handling functions.",
"ancestors":[{"title": "Appendixes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591a.htm"},{"title": "AutoLISP Function Synopsis","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4275.htm"},{"title": "Basic Functions","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b6a.htm"}]},
{"title":"Function-Handling Functions",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b61.htm",
"description":"The following table provides summary descriptions of the AutoLISP function-handling functions.",
"ancestors":[{"title": "Appendixes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591a.htm"},{"title": "AutoLISP Function Synopsis","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4275.htm"},{"title": "Basic Functions","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b6a.htm"}]},
{"title":"List Manipulation Functions",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b5f.htm",
"description":"The following table provides summary descriptions of the AutoLISP list manipulation functions.",
"ancestors":[{"title": "Appendixes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591a.htm"},{"title": "AutoLISP Function Synopsis","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4275.htm"},{"title": "Basic Functions","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b6a.htm"}]},
{"title":"String-Handling Functions",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b5d.htm",
"description":"The following table provides summary descriptions of the AutoLISP string-handling functions.",
"ancestors":[{"title": "Appendixes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591a.htm"},{"title": "AutoLISP Function Synopsis","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4275.htm"},{"title": "Basic Functions","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b6a.htm"}]},
{"title":"Symbol-Handling Functions",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b5b.htm",
"description":"The following table provides summary descriptions of the AutoLISP symbol-handling functions.",
"ancestors":[{"title": "Appendixes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591a.htm"},{"title": "AutoLISP Function Synopsis","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4275.htm"},{"title": "Basic Functions","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b6a.htm"}]},
{"title":"Utility Functions",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b59.htm",
"description":"The utility functions consist of query and command, display control, user input, geometric, conversion, file-handling, and device access functions.",
"ancestors":[{"title": "Appendixes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591a.htm"},{"title": "AutoLISP Function Synopsis","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4275.htm"}]},
{"title":"Conversion Functions",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b58.htm",
"description":"The following table provides summary descriptions of the AutoLISP conversion functions.",
"ancestors":[{"title": "Appendixes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591a.htm"},{"title": "AutoLISP Function Synopsis","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4275.htm"},{"title": "Utility Functions","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b59.htm"}]},
{"title":"Device Access Functions",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b56.htm",
"description":"The following table provides summary descriptions of the AutoLISP device access functions.",
"ancestors":[{"title": "Appendixes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591a.htm"},{"title": "AutoLISP Function Synopsis","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4275.htm"},{"title": "Utility Functions","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b59.htm"}]},
{"title":"Display Control Functions",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b54.htm",
"description":"The following table provides summary descriptions of the AutoLISP display control functions.",
"ancestors":[{"title": "Appendixes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591a.htm"},{"title": "AutoLISP Function Synopsis","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4275.htm"},{"title": "Utility Functions","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b59.htm"}]},
{"title":"File-Handling Functions",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b52.htm",
"description":"The following table provides summary descriptions of the AutoLISP file-handling functions.",
"ancestors":[{"title": "Appendixes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591a.htm"},{"title": "AutoLISP Function Synopsis","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4275.htm"},{"title": "Utility Functions","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b59.htm"}]},
{"title":"Geometric Functions",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b50.htm",
"description":"The following table provides summary descriptions of the AutoLISP geometric functions.",
"ancestors":[{"title": "Appendixes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591a.htm"},{"title": "AutoLISP Function Synopsis","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4275.htm"},{"title": "Utility Functions","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b59.htm"}]},
{"title":"Query and Command Functions",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b4e.htm",
"description":"The following table provides summary descriptions of the AutoLISP query and command functions.",
"ancestors":[{"title": "Appendixes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591a.htm"},{"title": "AutoLISP Function Synopsis","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4275.htm"},{"title": "Utility Functions","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b59.htm"}]},
{"title":"User Input Functions",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b4c.htm",
"description":"The following table provides summary descriptions of the AutoLISP user input functions.",
"ancestors":[{"title": "Appendixes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591a.htm"},{"title": "AutoLISP Function Synopsis","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4275.htm"},{"title": "Utility Functions","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b59.htm"}]},
{"title":"Selection Set, Object, and Symbol Table Functions",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b4a.htm",
"description":"The selection set, object, and symbol table functions consist of selection set manipulation, object-handling, extended data-handling, and symbol table-handling functions.",
"ancestors":[{"title": "Appendixes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591a.htm"},{"title": "AutoLISP Function Synopsis","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4275.htm"}]},
{"title":"Extended Data-Handling Functions",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b49.htm",
"description":"The following table provides summary descriptions of the AutoLISP extended data-handling functions.",
"ancestors":[{"title": "Appendixes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591a.htm"},{"title": "AutoLISP Function Synopsis","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4275.htm"},{"title": "Selection Set, Object, and Symbol Table Functions","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b4a.htm"}]},
{"title":"Object-Handling Functions",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b47.htm",
"description":"The following table provides summary descriptions of the AutoLISP object-handling functions.",
"ancestors":[{"title": "Appendixes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591a.htm"},{"title": "AutoLISP Function Synopsis","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4275.htm"},{"title": "Selection Set, Object, and Symbol Table Functions","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b4a.htm"}]},
{"title":"Selection Set Manipulation Functions",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b45.htm",
"description":"The following table provides summary descriptions of the AutoLISP selection set manipulation functions.",
"ancestors":[{"title": "Appendixes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591a.htm"},{"title": "AutoLISP Function Synopsis","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4275.htm"},{"title": "Selection Set, Object, and Symbol Table Functions","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b4a.htm"}]},
{"title":"Symbol Table and Dictionary-Handling Functions",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b43.htm",
"description":"The following table provides summary descriptions of the AutoLISP symbol table and dictionary-handling functions.",
"ancestors":[{"title": "Appendixes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591a.htm"},{"title": "AutoLISP Function Synopsis","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4275.htm"},{"title": "Selection Set, Object, and Symbol Table Functions","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b4a.htm"}]},
{"title":"Memory Management Functions",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b41.htm",
"description":"The following table provides summary descriptions of the AutoLISP memory management functions.",
"ancestors":[{"title": "Appendixes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591a.htm"},{"title": "AutoLISP Function Synopsis","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4275.htm"}]},
{"title":"Visual LISP Extensions to AutoLISP",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b3f.htm",
"description":"",
"ancestors":[{"title": "Appendixes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591a.htm"},{"title": "AutoLISP Function Synopsis","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4275.htm"}]},
{"title":"ActiveX Collection Manipulation Functions",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b3e.htm",
"description":"The following table provides summary descriptions of the AutoLISP ActiveX collection manipulation functions.",
"ancestors":[{"title": "Appendixes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591a.htm"},{"title": "AutoLISP Function Synopsis","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4275.htm"},{"title": "Visual LISP Extensions to AutoLISP","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b3f.htm"}]},
{"title":"ActiveX Data Conversion Functions",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b3c.htm",
"description":"The following table provides summary descriptions of the AutoLISP ActiveX data conversion functions.",
"ancestors":[{"title": "Appendixes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591a.htm"},{"title": "AutoLISP Function Synopsis","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4275.htm"},{"title": "Visual LISP Extensions to AutoLISP","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b3f.htm"}]},
{"title":"ActiveX Method Invocation Functions",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b3a.htm",
"description":"The following table provides summary descriptions of the AutoLISP ActiveX method invocation functions.",
"ancestors":[{"title": "Appendixes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591a.htm"},{"title": "AutoLISP Function Synopsis","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4275.htm"},{"title": "Visual LISP Extensions to AutoLISP","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b3f.htm"}]},
{"title":"ActiveX Object-Handling Functions",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b38.htm",
"description":"The following table provides summary descriptions of the AutoLISP ActiveX object-handling functions.",
"ancestors":[{"title": "Appendixes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591a.htm"},{"title": "AutoLISP Function Synopsis","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4275.htm"},{"title": "Visual LISP Extensions to AutoLISP","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b3f.htm"}]},
{"title":"ActiveX Property-Handling Functions",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b36.htm",
"description":"The following table provides summary descriptions of the AutoLISP property-handling functions.",
"ancestors":[{"title": "Appendixes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591a.htm"},{"title": "AutoLISP Function Synopsis","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4275.htm"},{"title": "Visual LISP Extensions to AutoLISP","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b3f.htm"}]},
{"title":"Curve Measurement Functions",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b34.htm",
"description":"",
"ancestors":[{"title": "Appendixes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591a.htm"},{"title": "AutoLISP Function Synopsis","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4275.htm"},{"title": "Visual LISP Extensions to AutoLISP","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b3f.htm"}]},
{"title":"Dictionary Functions",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b32.htm",
"description":"The following table provides summary descriptions of the AutoLISP dictionary functions.",
"ancestors":[{"title": "Appendixes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591a.htm"},{"title": "AutoLISP Function Synopsis","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4275.htm"},{"title": "Visual LISP Extensions to AutoLISP","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b3f.htm"}]},
{"title":"Functions for Handling Drawing Objects",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b30.htm",
"description":"The following table provides summary descriptions of the AutoLISP functions for handling drawing objects.",
"ancestors":[{"title": "Appendixes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591a.htm"},{"title": "AutoLISP Function Synopsis","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4275.htm"},{"title": "Visual LISP Extensions to AutoLISP","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b3f.htm"}]},
{"title":"Reactor Functions",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b2e.htm",
"description":"Reactor functions define, query, and delete reactors and reactor properties.",
"ancestors":[{"title": "Appendixes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591a.htm"},{"title": "AutoLISP Function Synopsis","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4275.htm"}]},
{"title":"VLX Namespace Functions",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b2c.htm",
"description":"The VLX namespace functions listed below apply to separate-namespace VLX applications. These functions allow separate-namespace VLX functions to be accessible from a document namespace, enable the retrieval and updating of variables in the associated document namespace, and provide error-handling routines for separate-namespace VLX functions.",
"ancestors":[{"title": "Appendixes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591a.htm"},{"title": "AutoLISP Function Synopsis","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4275.htm"}]},
{"title":"Namespace Communication Functions",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b2a.htm",
"description":"The namespace communication functions consist of blackboard addressing and multi-document-loading functions.",
"ancestors":[{"title": "Appendixes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591a.htm"},{"title": "AutoLISP Function Synopsis","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4275.htm"}]},
{"title":"Windows Registry Functions",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b28.htm",
"description":"Windows Registry functions query and update the Windows Registry.",
"ancestors":[{"title": "Appendixes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591a.htm"},{"title": "AutoLISP Function Synopsis","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4275.htm"}]},
{"title":"Visual LISP Environment and Formatting Options",
"href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4138.htm",
"description":"Color-coding options, diagnostic options, and page layout options are described.",
"ancestors":[{"title": "Appendixes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591a.htm"}]},
{"title":"Window Attributes Options",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b84.htm",
"description":"On the Visual LISP Tools menu, the Window Attributes submenu includes options for customizing the VLISP windowing environment, controlling attributes such as colors, fonts, and code formatting. The Syntax Coloring, Current to Prototype, and All to Prototype options are available only for text editor windows.",
"ancestors":[{"title": "Appendixes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591a.htm"},{"title": "Visual LISP Environment and Formatting Options","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4138.htm"}]},
{"title":"Syntax Coloring",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b82.htm",
"description":"On the Visual LISP Tools menu, on the Window Attributes submenu, the Syntax Coloring option determines the type of syntax coloring that will be used for the current file being edited. This option is available when you edit a file whose file type is not .lsp. When chosen, Syntax Coloring displays the Color Style dialog box, which provides the following options:",
"ancestors":[{"title": "Appendixes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591a.htm"},{"title": "Visual LISP Environment and Formatting Options","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4138.htm"},{"title": "Window Attributes Options","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b84.htm"}]},
{"title":"Configure Current",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b81.htm",
"description":"On the Visual LISP Tools menu, on the Window Attributes submenu, the Configure Current option allows you to configure the attributes of the current window. It is applicable to the VLISP text editor and Console windows. The Configure Current option displays the Window Attributes dialog box:",
"ancestors":[{"title": "Appendixes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591a.htm"},{"title": "Visual LISP Environment and Formatting Options","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4138.htm"},{"title": "Window Attributes Options","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b84.htm"}]},
{"title":"Set Current Window to Prototype",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b7d.htm",
"description":"On the Visual LISP Tools menu, on the Window Attributes submenu, the Set Current Window to Prototype option configures the current active window with the attributes of the prototype window.",
"ancestors":[{"title": "Appendixes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591a.htm"},{"title": "Visual LISP Environment and Formatting Options","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4138.htm"},{"title": "Window Attributes Options","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b84.htm"}]},
{"title":"Set All Windows to Prototype",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b7c.htm",
"description":"On the Visual LISP Tools menu, on the Window Attributes submenu, the Set All Windows to Prototype option sets all open windows with the attributes of the prototype.",
"ancestors":[{"title": "Appendixes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591a.htm"},{"title": "Visual LISP Environment and Formatting Options","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4138.htm"},{"title": "Window Attributes Options","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b84.htm"}]},
{"title":"Font",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b7b.htm",
"description":"On the Visual LISP Tools menu, on the Window Attributes submenu, the font option opens a standard Windows Font dialog box where you can select the font to be used in VLISP windows.",
"ancestors":[{"title": "Appendixes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591a.htm"},{"title": "Visual LISP Environment and Formatting Options","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4138.htm"},{"title": "Window Attributes Options","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b84.htm"}]},
{"title":"Environment Options",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b7a.htm",
"description":"On the Visual LISP Tools menu, the Environment Options submenu allows you to set session-wide VLISP options. For example, you can tell VLISP whether to save text editor files at set intervals automatically, whether to create automatic backup files, and how you want to treat attempts to modify protected symbols. Environment Options is also where you set diagnostic options, such as what statistics to report during syntax checking, and what level of detail to display when inspecting drawing objects. You can also set formatting options for AutoLISP code, and page layout options for printed output.",
"ancestors":[{"title": "Appendixes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591a.htm"},{"title": "Visual LISP Environment and Formatting Options","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4138.htm"}]},
{"title":"General Options Dialog Box",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b79.htm",
"description":"On the Visual LISP Tools menu, on the Environment Options submenu, the General Options option displays the General Options dialog box containing the General and Diagnostic tabs.",
"ancestors":[{"title": "Appendixes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591a.htm"},{"title": "Visual LISP Environment and Formatting Options","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4138.htm"},{"title": "Environment Options","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b7a.htm"}]},
{"title":"General Tab (General Options Dialog Box)",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b78.htm",
"description":"On the Visual LISP Tools menu, on the Environment Options submenu, the General Options option displays the General Options dialog box. In the General Options dialog box, on the General tab, there are three groups of options: Editor Options, Desktop, and SETQ to Protected Symbols.",
"ancestors":[{"title": "Appendixes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591a.htm"},{"title": "Visual LISP Environment and Formatting Options","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4138.htm"},{"title": "Environment Options","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b7a.htm"},{"title": "General Options Dialog Box","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b79.htm"}]},
{"title":"Diagnostic Tab (General Options Dialog Box)",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b76.htm",
"description":"On the Visual LISP Tools menu, on the Environment Options submenu, the General Options option displays the General Options dialog box. In the General Options dialog box, on the Diagnostic tab, the options control how VLISP provides information about AutoLISP syntax.",
"ancestors":[{"title": "Appendixes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591a.htm"},{"title": "Visual LISP Environment and Formatting Options","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4138.htm"},{"title": "Environment Options","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b7a.htm"},{"title": "General Options Dialog Box","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b79.htm"}]},
{"title":"Visual LISP Format Options",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b74.htm",
"description":"On the Visual LISP Tools menu, on the Environment Options submenu, the Visual LISP Format Options option displays the Format Options dialog box, which is used to set formatting and indentation options.",
"ancestors":[{"title": "Appendixes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591a.htm"},{"title": "Visual LISP Environment and Formatting Options","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4138.htm"},{"title": "Environment Options","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b7a.htm"}]},
{"title":"Base Formatting Options in the Format Options Dialog Box",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b72.htm",
"description":"The following options are shown at the top of the Format Options dialog box.",
"ancestors":[{"title": "Appendixes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591a.htm"},{"title": "Visual LISP Environment and Formatting Options","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4138.htm"},{"title": "Environment Options","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b7a.htm"},{"title": "Visual LISP Format Options","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b74.htm"}]},
{"title":"Additional Formatting Options in the Format Options Dialog Box",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b71.htm",
"description":"Additional formatting options appear when you press the More Options button in the Format Options dialog box.",
"ancestors":[{"title": "Appendixes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591a.htm"},{"title": "Visual LISP Environment and Formatting Options","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4138.htm"},{"title": "Environment Options","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b7a.htm"},{"title": "Visual LISP Format Options","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b74.htm"}]},
{"title":"Page Format Options in the Page Setup Dialog Box",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b70.htm",
"description":"Page format options are shown in the Page Setup Dialog Box.",
"ancestors":[{"title": "Appendixes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591a.htm"},{"title": "Visual LISP Environment and Formatting Options","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4138.htm"},{"title": "Environment Options","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b7a.htm"}]},
{"title":"Justification and Substitution Codes in the Page Setup Dialog Box",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b6f.htm",
"description":"When you specify a header and footer in the Page Setup dialog box, only the ampersand character (&) is considered as an escape character. Both the ampersand and the character that follows are not copied to the output line. Instead, they either justify the following text, or VLISP replaces them with variable information.",
"ancestors":[{"title": "Appendixes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591a.htm"},{"title": "Visual LISP Environment and Formatting Options","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4138.htm"},{"title": "Environment Options","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b7a.htm"},{"title": "Page Format Options in the Page Setup Dialog Box","href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b70.htm"}]},
{"title":"Save Settings (Tools Menu)",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b6e.htm",
"description":"The Save Settings option on the Visual LISP Tools menu saves the desktop configuration and options settings. Note that the desktop configuration for the child windows attributes (their presence on the screen, color, position, files loaded) is saved only when the Save Editor Windows Settings option in the General Options dialog box is turned on.",
"ancestors":[{"title": "Appendixes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591a.htm"},{"title": "Visual LISP Environment and Formatting Options","href":"./filesALG/WSfacf1429558a55de185c428100849a0ab7-4138.htm"}]},
{"title":"AutoLISP Error Codes",
"href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-5919.htm",
"description":"The error codes generated by AutoLISP are described.",
"ancestors":[{"title": "Appendixes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591a.htm"}]},
{"title":"Error Codes",
"href":"./filesALG/WS73099cc142f4875516d84be10ebc87a53f-7b86.htm",
"description":"The following table shows the values of error codes generated by AutoLISP. The ERRNO system variable is set to one of these values when an AutoLISP function call causes an error that AutoCAD detects. AutoLISP applications can inspect the current value of ERRNO with (getvar \"errno\").",
"ancestors":[{"title": "Appendixes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-591a.htm"},{"title": "AutoLISP Error Codes","href":"./filesALG/WSfacf1429558a55de1a7524c1004e616f8b-5919.htm"}]},
]);
top.HlpSys.search.data.registerSearchProvider(searchResultProvider);
// SIG // Begin signature block
// SIG // MIIMzQYJKoZIhvcNAQcCoIIMvjCCDLoCAQExDjAMBggq
// SIG // hkiG9w0CBQUAMGYGCisGAQQBgjcCAQSgWDBWMDIGCisG
// SIG // AQQBgjcCAR4wJAIBAQQQEODJBs441BGiowAQS9NQkAIB
// SIG // AAIBAAIBAAIBAAIBADAgMAwGCCqGSIb3DQIFBQAEEFWn
// SIG // WTr76+7toTdfv2pnXiygggoPMIIE/DCCBGWgAwIBAgIQ
// SIG // ZVIm4bIuGOFZDymFrCLnXDANBgkqhkiG9w0BAQUFADBf
// SIG // MQswCQYDVQQGEwJVUzEXMBUGA1UEChMOVmVyaVNpZ24s
// SIG // IEluYy4xNzA1BgNVBAsTLkNsYXNzIDMgUHVibGljIFBy
// SIG // aW1hcnkgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkwHhcN
// SIG // MDkwNTIxMDAwMDAwWhcNMTkwNTIwMjM1OTU5WjCBtjEL
// SIG // MAkGA1UEBhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJ
// SIG // bmMuMR8wHQYDVQQLExZWZXJpU2lnbiBUcnVzdCBOZXR3
// SIG // b3JrMTswOQYDVQQLEzJUZXJtcyBvZiB1c2UgYXQgaHR0
// SIG // cHM6Ly93d3cudmVyaXNpZ24uY29tL3JwYSAoYykwOTEw
// SIG // MC4GA1UEAxMnVmVyaVNpZ24gQ2xhc3MgMyBDb2RlIFNp
// SIG // Z25pbmcgMjAwOS0yIENBMIIBIjANBgkqhkiG9w0BAQEF
// SIG // AAOCAQ8AMIIBCgKCAQEAvmcdtGCqEElvVhd8Zslehg3V
// SIG // 8ayncYOOi4n4iASJFQa6LYQhleTRnFBM+9IivdrysjU7
// SIG // Ho/DCfv8Ey5av4l8PTslHvbzWHuc9AG1xgq4gM6+J3Rh
// SIG // ZydNauXsgWFYeaPgFxASFSew4U00fytHIES53mYkZorN
// SIG // T7ofxTjIVJDhcvYZZnVquUlozzh5DaowqNssYEie16oU
// SIG // AamD1ziRMDkTlgM6fEBUtq3gLxuD3KgRUj4Cs9cr/SG2
// SIG // p1yjDwupphBQDjQuTafOyV4l1Iy88258KbwBXfwxh1rV
// SIG // jIVnWIgZoL818OoroyHnkPaD5ajtYHhee2CD/VcLXUEN
// SIG // Y1Rg1kMh7wIDAQABo4IB2zCCAdcwEgYDVR0TAQH/BAgw
// SIG // BgEB/wIBADBwBgNVHSAEaTBnMGUGC2CGSAGG+EUBBxcD
// SIG // MFYwKAYIKwYBBQUHAgEWHGh0dHBzOi8vd3d3LnZlcmlz
// SIG // aWduLmNvbS9jcHMwKgYIKwYBBQUHAgIwHhocaHR0cHM6
// SIG // Ly93d3cudmVyaXNpZ24uY29tL3JwYTAOBgNVHQ8BAf8E
// SIG // BAMCAQYwbQYIKwYBBQUHAQwEYTBfoV2gWzBZMFcwVRYJ
// SIG // aW1hZ2UvZ2lmMCEwHzAHBgUrDgMCGgQUj+XTGoasjY5r
// SIG // w8+AatRIGCx7GS4wJRYjaHR0cDovL2xvZ28udmVyaXNp
// SIG // Z24uY29tL3ZzbG9nby5naWYwHQYDVR0lBBYwFAYIKwYB
// SIG // BQUHAwIGCCsGAQUFBwMDMDQGCCsGAQUFBwEBBCgwJjAk
// SIG // BggrBgEFBQcwAYYYaHR0cDovL29jc3AudmVyaXNpZ24u
// SIG // Y29tMDEGA1UdHwQqMCgwJqAkoCKGIGh0dHA6Ly9jcmwu
// SIG // dmVyaXNpZ24uY29tL3BjYTMuY3JsMCkGA1UdEQQiMCCk
// SIG // HjAcMRowGAYDVQQDExFDbGFzczNDQTIwNDgtMS01NTAd
// SIG // BgNVHQ4EFgQUl9BrqCZwyKE/lB8ILcQ1m6ShHvIwDQYJ
// SIG // KoZIhvcNAQEFBQADgYEAiwPA3ZTYQaJhabAVqHjHMMaQ
// SIG // PH5C9yS25INzFwR/BBCcoeL6gS/rwMpE53LgULZVECCD
// SIG // bpaS5JpRarQ3MdylLeuMAMcdT+dNMrqF+E6++mdVZfBq
// SIG // vnrKZDgaEBB4RXYx84Z6Aw9gwrNdnfaLZnaCG1nhg+W9
// SIG // SaU4VuXeQXcOWA8wggULMIID86ADAgECAhAjTaBL0kKF
// SIG // PErLmuhhwhm7MA0GCSqGSIb3DQEBBQUAMIG2MQswCQYD
// SIG // VQQGEwJVUzEXMBUGA1UEChMOVmVyaVNpZ24sIEluYy4x
// SIG // HzAdBgNVBAsTFlZlcmlTaWduIFRydXN0IE5ldHdvcmsx
// SIG // OzA5BgNVBAsTMlRlcm1zIG9mIHVzZSBhdCBodHRwczov
// SIG // L3d3dy52ZXJpc2lnbi5jb20vcnBhIChjKTA5MTAwLgYD
// SIG // VQQDEydWZXJpU2lnbiBDbGFzcyAzIENvZGUgU2lnbmlu
// SIG // ZyAyMDA5LTIgQ0EwHhcNMDkwODI3MDAwMDAwWhcNMTIw
// SIG // OTIwMjM1OTU5WjCByDELMAkGA1UEBhMCVVMxEzARBgNV
// SIG // BAgTCkNhbGlmb3JuaWExEzARBgNVBAcTClNhbiBSYWZh
// SIG // ZWwxFjAUBgNVBAoUDUF1dG9kZXNrLCBJbmMxPjA8BgNV
// SIG // BAsTNURpZ2l0YWwgSUQgQ2xhc3MgMyAtIE1pY3Jvc29m
// SIG // dCBTb2Z0d2FyZSBWYWxpZGF0aW9uIHYyMR8wHQYDVQQL
// SIG // FBZEZXNpZ24gU29sdXRpb25zIEdyb3VwMRYwFAYDVQQD
// SIG // FA1BdXRvZGVzaywgSW5jMIGfMA0GCSqGSIb3DQEBAQUA
// SIG // A4GNADCBiQKBgQC1R1YKdvQF2Rj4+knWfj81afUtVyep
// SIG // GF2P4tcYD53qlYmYi9t9Csc6PMWlUZhMGbOceQKYcBjc
// SIG // mWvyghJnoaEQ6796ZcsLD0pMH2R4SpV/SjxiQ280beig
// SIG // NerJS5X+ftOMCs1qSQ1LXlRFEohaewkNWsIp/+f1Y0vE
// SIG // dGzggnEKOQIDAQABo4IBgzCCAX8wCQYDVR0TBAIwADAO
// SIG // BgNVHQ8BAf8EBAMCB4AwRAYDVR0fBD0wOzA5oDegNYYz
// SIG // aHR0cDovL2NzYzMtMjAwOS0yLWNybC52ZXJpc2lnbi5j
// SIG // b20vQ1NDMy0yMDA5LTIuY3JsMEQGA1UdIAQ9MDswOQYL
// SIG // YIZIAYb4RQEHFwMwKjAoBggrBgEFBQcCARYcaHR0cHM6
// SIG // Ly93d3cudmVyaXNpZ24uY29tL3JwYTATBgNVHSUEDDAK
// SIG // BggrBgEFBQcDAzB1BggrBgEFBQcBAQRpMGcwJAYIKwYB
// SIG // BQUHMAGGGGh0dHA6Ly9vY3NwLnZlcmlzaWduLmNvbTA/
// SIG // BggrBgEFBQcwAoYzaHR0cDovL2NzYzMtMjAwOS0yLWFp
// SIG // YS52ZXJpc2lnbi5jb20vQ1NDMy0yMDA5LTIuY2VyMB8G
// SIG // A1UdIwQYMBaAFJfQa6gmcMihP5QfCC3ENZukoR7yMBEG
// SIG // CWCGSAGG+EIBAQQEAwIEEDAWBgorBgEEAYI3AgEbBAgw
// SIG // BgEBAAEB/zANBgkqhkiG9w0BAQUFAAOCAQEAIfxkh8Fd
// SIG // IHK+qtTf+9Eq5fjkk5gMMTQCOa+2aR7mqDzLfIFRGQzr
// SIG // tcc5/izsb/wPLUwdw1cRpnxO8/qLA2Ol+b99FONTOyyc
// SIG // Y8unwviYhdEjuFmqHkyC5MUYroZEjvTObFkkgN98Y48h
// SIG // C+mG2hdlVKXR0zr9r5q/rmmivVWbojvcYKHoW31O5OcM
// SIG // PsrWuOD305Ygmpck/91iopE3UN4tfeWYhzNj1F6Ai4Xa
// SIG // 5KiaMcs3zmoZ+6SePyI2YUgtff6yvy/rk8KVT41KGD2h
// SIG // fC+QrtVSkoDWP/MDtLjbTPCWElC1NWSEKowRI8t2x594
// SIG // Skjnzu/W5Lh97ixircOuM4IvBzGCAigwggIkAgEBMIHL
// SIG // MIG2MQswCQYDVQQGEwJVUzEXMBUGA1UEChMOVmVyaVNp
// SIG // Z24sIEluYy4xHzAdBgNVBAsTFlZlcmlTaWduIFRydXN0
// SIG // IE5ldHdvcmsxOzA5BgNVBAsTMlRlcm1zIG9mIHVzZSBh
// SIG // dCBodHRwczovL3d3dy52ZXJpc2lnbi5jb20vcnBhIChj
// SIG // KTA5MTAwLgYDVQQDEydWZXJpU2lnbiBDbGFzcyAzIENv
// SIG // ZGUgU2lnbmluZyAyMDA5LTIgQ0ECECNNoEvSQoU8Ssua
// SIG // 6GHCGbswDAYIKoZIhvcNAgUFAKCBsDAZBgkqhkiG9w0B
// SIG // CQMxDAYKKwYBBAGCNwIBBDAcBgorBgEEAYI3AgELMQ4w
// SIG // DAYKKwYBBAGCNwIBFTAfBgkqhkiG9w0BCQQxEgQQm8HT
// SIG // F8AJ20+v9n5B1i7gaTBUBgorBgEEAYI3AgEMMUYwRKAm
// SIG // gCQAQQB1AHQAbwBkAGUAcwBrACAAQwBvAG0AcABvAG4A
// SIG // ZQBuAHShGoAYaHR0cDovL3d3dy5hdXRvZGVzay5jb20g
// SIG // MA0GCSqGSIb3DQEBAQUABIGAUwXOaqb0msCtbDR5AYUO
// SIG // wufAZ2fCkDMWelGtCHhTfij+SZBNhxVxuKyspk7QsqMp
// SIG // fr9o9mJwqOZmloPitJ7t6J2Pj/uDyat6rW0N4VukQ/8K
// SIG // j2fq5Mp+rX1SV9wsfBT9hsp64hTXkVTohkrxoHCL/A1G
// SIG // JBrGxAM+wAsXXC/6HH0=
// SIG // End signature block
